/*
 * Decompiled with CFR 0.152.
 */
package ga.strikepractice.stats;

import ga.strikepractice.StrikePractice;
import ga.strikepractice.api.APIClass;
import ga.strikepractice.battlekit.BattleKit;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

@APIClass
public interface PlayerStats {
    public void checkMatchLimitUpdate(boolean var1, boolean var2);

    public void checkAndResetNow();

    public int getRankedsLeft();

    public int getUnrankedsLeft();

    public long getLimitsUpdated();

    public void setRankedsLeft(int var1);

    public void setUnrankedsLeft(int var1);

    public boolean removeRanked();

    public boolean removeUnranked();

    public int getKills();

    public void setKills(int var1);

    public int getDeaths();

    public void setDeaths(int var1);

    public int getBracketsWins();

    public void setBracketsWins(int var1);

    public int getPartyVsPartyWins();

    public void setPartyVsPartyWins(int var1);

    public int getLMSWins();

    public void setLmsWins(int var1);

    public int getGlobalElo();

    public int getPremiumMatches();

    public void setPremiumMatches(int var1);

    @Deprecated
    default public HashMap<String, Integer> getElos() {
        Map<String, Integer> map = this.getPlayerElos();
        return (HashMap)map;
    }

    public Map<String, Integer> getPlayerElos();

    @Deprecated
    default public void setElos(HashMap<String, Integer> elos) {
        this.setPlayerElos(elos);
    }

    public void setPlayerElos(Map<String, Integer> var1);

    public int getSumoWins();

    public void setSumoWins(int var1);

    public int getJuggernautWins();

    public void setJuggernautWins(int var1);

    default public int getEventWins() {
        return this.getLMSWins() + this.getBracketsWins() + this.getJuggernautWins() + this.getSumoWins();
    }

    public boolean isOnCooldown(String var1);

    public boolean isOnCooldown(String var1, boolean var2);

    public String getCooldownString(String var1);

    public void putOnCooldown(String var1, long var2);

    public int getElo(String var1);

    public int getElo(BattleKit var1);

    public UUID getUUID();

    public void save();

    public boolean shouldSave();

    @Deprecated
    default public HashMap<String, Long> getCooldowns() {
        Map<String, Long> map = this.getPlayerCooldowns();
        return (HashMap)map;
    }

    public Map<String, Long> getPlayerCooldowns();

    public CachedStatistic<Integer> getLosses();

    public CachedStatistic<Integer> getWins();

    public CachedStatistic<Integer> getWins(BattleKit var1);

    public CachedStatistic<Integer> getLosses(BattleKit var1);

    public CachedStatistic<Integer> getWinStreak();

    public CachedStatistic<Integer> getWinStreak(BattleKit var1);

    public void save(boolean var1);

    @APIClass
    public static abstract class CachedStatistic<T> {
        private static final ExecutorService executor = ForkJoinPool.commonPool();
        private static final long CACHE_MAX_AGE = TimeUnit.SECONDS.toMillis(StrikePractice.getInstance().getConfig().getLong("cached-stats-max-age"));
        private static final boolean NO_QUERY_STATS = StrikePractice.getInstance().getConfig().getBoolean("disable-queried-stats");
        protected long lastUpdateStarted;
        protected T cached;
        protected Supplier<T> fetcher;

        protected CachedStatistic(Supplier<T> fetcher) {
            this.fetcher = fetcher;
        }

        public T getCached() {
            return this.cached;
        }

        public T getAndRequestUpdate(long maxCacheAge) {
            this.requestUpdate(null, maxCacheAge);
            return this.getCached();
        }

        public T getAndRequestUpdate() {
            return this.getAndRequestUpdate(CACHE_MAX_AGE);
        }

        protected void setCached(T cached) {
            this.cached = cached;
            this.lastUpdateStarted = System.currentTimeMillis();
        }

        public void invalidateCache() {
            this.lastUpdateStarted = 0L;
            this.cached = null;
        }

        public long getLastUpdateStarted() {
            return this.lastUpdateStarted;
        }

        @Deprecated
        public long getLastUpdate() {
            return this.lastUpdateStarted;
        }

        public void requestUpdate(@Nullable Consumer<T> callback, long maxCacheAgeMs) {
            if (NO_QUERY_STATS || !StrikePractice.getInstance().isMySQL || !StrikePractice.getInstance().mySQL.isFightsTable) {
                return;
            }
            if (System.currentTimeMillis() - this.lastUpdateStarted < maxCacheAgeMs) {
                if (callback != null) {
                    callback.accept(this.cached);
                }
            } else {
                this.lastUpdateStarted = System.currentTimeMillis();
                executor.submit(() -> {
                    T res = this.fetcher.get();
                    this.setCached(res);
                    if (callback != null) {
                        callback.accept(res);
                    }
                });
            }
        }

        public void requestUpdate(@Nullable Consumer<T> callback) {
            this.requestUpdate(callback, CACHE_MAX_AGE);
        }
    }
}

