/*
 * Decompiled with CFR 0.152.
 */
package ga.strikepractice.playersettings;

import ga.strikepractice.StrikePractice;
import ga.strikepractice.api.APIClass;
import ga.strikepractice.data.flatfile.PlayerDataFile;
import ga.strikepractice.events.LanguageSelectEvent;
import ga.strikepractice.language.LanguageManager;
import ga.strikepractice.utils.MapUtil;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

@APIClass
public class PlayerSettings {
    private static final Map<UUID, PlayerSettings> settings = new ConcurrentHashMap<UUID, PlayerSettings>();
    private final UUID uuid;
    private String language;
    private boolean scoreboardDisabled;
    private boolean duelRequestsDisabled;
    private boolean adminScoreboard;
    private boolean hideOtherPlayers;

    public PlayerSettings(UUID uuid) {
        this.uuid = uuid;
        settings.put(uuid, this);
        this.load();
    }

    private void load() {
        PlayerDataFile f2 = new PlayerDataFile(StrikePractice.getInstance(), this.uuid);
        YamlConfiguration conf = f2.getConfig();
        String lang = conf.getString("language");
        this.setLanguage(lang, StrikePractice.getInstance(), false);
        this.scoreboardDisabled = conf.getBoolean("scoreboard-disabled");
        this.duelRequestsDisabled = conf.getBoolean("duel-requests-disabled");
        this.adminScoreboard = conf.getBoolean("admin-scoreboard");
        this.hideOtherPlayers = conf.getBoolean("hide-other-players");
    }

    public void save() {
        PlayerDataFile f2 = new PlayerDataFile(StrikePractice.getInstance(), this.uuid);
        YamlConfiguration conf = f2.getConfig();
        conf.set("language", (Object)this.language);
        conf.set("scoreboard-disabled", (Object)this.scoreboardDisabled);
        conf.set("duel-requests-disabled", (Object)this.duelRequestsDisabled);
        if (this.adminScoreboard || conf.getBoolean("admin-scoreboard")) {
            conf.set("admin-scoreboard", (Object)this.adminScoreboard);
        }
        conf.set("hide-other-players", (Object)this.hideOtherPlayers);
        f2.save();
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language, StrikePractice plugin, boolean message) {
        Player p2 = Bukkit.getPlayer((UUID)this.uuid);
        if (language == null || language.equals("null")) {
            language = LanguageManager.getDefaultLanguage((Player)p2);
        }
        String lang = language;
        Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
            LanguageSelectEvent event = new LanguageSelectEvent(p2, lang);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.language = event.getLanguage();
                if (message && p2 != null) {
                    plugin.sendMessage(p2, "language-set", MapUtil.mapOf((Object[])new Object[]{"<language>", lang}));
                }
            }
        });
    }

    public boolean isScoreboardDisabled() {
        return this.scoreboardDisabled;
    }

    public void setScoreboardDisabled(boolean scoreboardDisabled) {
        this.scoreboardDisabled = scoreboardDisabled;
    }

    public boolean isDuelRequestsDisabled() {
        return this.duelRequestsDisabled;
    }

    public boolean isHideOtherPlayers() {
        return this.hideOtherPlayers;
    }

    public void setHideOtherPlayers(boolean hideOtherPlayers) {
        this.hideOtherPlayers = hideOtherPlayers;
    }

    public void setDuelRequestsDisabled(boolean duelRequestsDisabled) {
        this.duelRequestsDisabled = duelRequestsDisabled;
    }

    public static Map<UUID, PlayerSettings> getSettings() {
        return settings;
    }

    public boolean isAdminScoreboard() {
        return this.adminScoreboard;
    }

    public void setAdminScoreboard(boolean adminScoreboard) {
        this.adminScoreboard = adminScoreboard;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public static PlayerSettings getPlayerSettings(UUID uuid) {
        PlayerSettings ps = settings.get(uuid);
        if (ps != null) {
            return ps;
        }
        PlayerSettings pSettings = new PlayerSettings(uuid);
        settings.put(uuid, pSettings);
        return pSettings;
    }

    public static PlayerSettings getPlayerSettings(Player p2) {
        return PlayerSettings.getPlayerSettings(p2.getUniqueId());
    }

    public static boolean isStatsLoaded(Player p2) {
        return settings.containsKey(p2.getUniqueId());
    }
}

