/*
 * Decompiled with CFR 0.152.
 */
package ga.strikepractice.playerkits;

import ga.strikepractice.StrikePractice;
import ga.strikepractice.api.APIClass;
import ga.strikepractice.battlekit.BattleKit;
import ga.strikepractice.data.flatfile.PlayerDataFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.configuration.file.YamlConfiguration;

@APIClass
public class PlayerKits {
    private List<BattleKit> editedKits = new ArrayList<BattleKit>();
    private BattleKit customKit;
    private UUID player;

    public PlayerKits(UUID player) {
        this.player = player;
    }

    public BattleKit getEditedKit(BattleKit kit, boolean onlyOwn) {
        for (BattleKit bk : this.editedKits) {
            if (!kit.getName().equals(bk.getName())) continue;
            return bk;
        }
        return onlyOwn ? null : kit;
    }

    public BattleKit getEditedKit(String kit) {
        for (BattleKit bk : this.editedKits) {
            if (!kit.equals(bk.getName())) continue;
            return bk;
        }
        return null;
    }

    public BattleKit[] getEditedKitByFancyName(String fancyName) {
        return (BattleKit[])this.editedKits.stream().filter(bk -> fancyName.equals(bk.getFancyName())).toArray(BattleKit[]::new);
    }

    public void savePlayerKitsToFile() {
        StrikePractice plugin = StrikePractice.getInstance();
        PlayerDataFile f2 = new PlayerDataFile(plugin, this.player);
        YamlConfiguration conf = f2.getConfig();
        BattleKit kit = this.getCustomKit();
        if (kit != null) {
            conf.set("custom-kit", (Object)kit);
        }
        conf.set("kits", this.editedKits);
        f2.save();
    }

    public boolean removeEditedKitIndex(String kitWithIndex) {
        return this.editedKits.removeIf(kit -> kit.getName().equals(kitWithIndex));
    }

    public boolean removeEditedKits(String serverKit) {
        boolean removed = false;
        ArrayList<BattleKit> kitsToRemove = new ArrayList<BattleKit>();
        for (BattleKit kit : this.editedKits) {
            String kitName = kit.getName();
            if (!kitName.startsWith(serverKit + "-") && !kitName.equals(serverKit)) continue;
            kitsToRemove.add(kit);
            removed = true;
        }
        this.editedKits.removeAll(kitsToRemove);
        return removed;
    }

    public List<BattleKit> getEditedKits() {
        return this.editedKits;
    }

    public void setEditedKits(List<BattleKit> editedKits) {
        this.editedKits = editedKits;
    }

    public BattleKit getCustomKit() {
        return this.customKit;
    }

    public void setCustomKit(BattleKit customKit) {
        this.customKit = customKit;
    }

    public UUID getPlayer() {
        return this.player;
    }

    public void setPlayer(UUID player) {
        this.player = player;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        PlayerKits that = (PlayerKits)o2;
        return this.editedKits.equals(that.editedKits) && this.customKit.equals(that.customKit) && this.player.equals(that.player);
    }

    public int hashCode() {
        return Objects.hash(this.editedKits, this.customKit, this.player);
    }
}

