/*
 * Decompiled with CFR 0.152.
 */
package ga.strikepractice.npc;

import ga.strikepractice.StrikePractice;
import ga.strikepractice.api.APIClass;
import ga.strikepractice.battlekit.BattleKit;
import ga.strikepractice.bot.PracticeBot;
import ga.strikepractice.fights.Fight;
import ga.strikepractice.matchrecorder.Damage;
import ga.strikepractice.misc.FirstOfApril;
import ga.strikepractice.npc.CombatTask;
import ga.strikepractice.utils.ItemFlagUtil;
import ga.strikepractice.utils.NPCUtil;
import ga.strikepractice.utils.SPDebugger;
import ga.strikepractice.utils.SoundManager;
import ga.strikepractice.utils.VersionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.PlayerAnimation;
import org.bukkit.Bukkit;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

@APIClass
public class CitizensNPC
extends PracticeBot {
    private final StrikePractice plugin;
    public static final List<CitizensNPC> npcs = Collections.synchronizedList(new ArrayList());
    private static boolean teleportFix;
    final Location spawnLocation;
    public CombatTask combatTask;
    private boolean destroyed;

    public CitizensNPC(String name, String skin, Location loc) {
        if (SPDebugger.getDEBUG()) {
            SPDebugger.debug((String)("Creating a new bot. Existing: " + npcs.size()));
        }
        this.plugin = StrikePractice.getInstance();
        this.spawnLocation = loc;
        this.npc = NPCUtil.getRegistry().createNPC(EntityType.PLAYER, name);
        if (!this.plugin.getConfig().getBoolean("no-bot-skins")) {
            if (this.plugin.getConfig().getBoolean("always-same-skin")) {
                this.npc.data().set("player-skin-name", (Object)this.plugin.getConfig().getString("bot-skin"));
            } else {
                this.npc.data().set("player-skin-name", (Object)skin);
            }
        }
        FirstOfApril.handleSkin((NPC)this.npc);
        if (this.npc.isSpawned()) {
            this.npc.despawn();
        }
        new /* Unavailable Anonymous Inner Class!! */.runTaskTimer((Plugin)this.plugin, 0L, 2L);
        npcs.add(this);
    }

    public static void onEnable() {
        StrikePractice plugin = StrikePractice.getInstance();
        teleportFix = plugin.getConfig().getBoolean("bot-teleport-error-fix");
        new /* Unavailable Anonymous Inner Class!! */.runTaskLater((Plugin)plugin, 20L);
    }

    public static double getDamage(ItemStack item) {
        if (VersionUtil.IS_13_PLUS) {
            return CitizensNPC.getDamageNoId(item);
        }
        return CitizensNPC.getDamageId(item);
    }

    public static double getDamageId(ItemStack item) {
        double d2;
        switch (item.getTypeId()) {
            case 257: 
            case 268: 
            case 275: 
            case 277: 
            case 283: {
                d2 = 4.0;
                break;
            }
            case 258: 
            case 272: 
            case 278: {
                d2 = 5.0;
                break;
            }
            case 267: 
            case 279: {
                d2 = 6.0;
                break;
            }
            case 276: {
                d2 = 7.0;
                break;
            }
            case 270: 
            case 273: 
            case 285: {
                d2 = 2.0;
                break;
            }
            case 256: 
            case 271: 
            case 274: 
            case 286: {
                d2 = 3.0;
                break;
            }
            default: {
                d2 = 1.0;
            }
        }
        return d2;
    }

    public static double getDamageNoId(ItemStack item) {
        double d2;
        switch (item.getType().toString()) {
            case "WOOD_SWORD": 
            case "GOLD_SWORD": 
            case "DIAMOND_SPADE": 
            case "IRON_PICKAXE": 
            case "STONE_AXE": {
                d2 = 4.0;
                break;
            }
            case "STONE_SWORD": 
            case "DIAMOND_PICKAXE": 
            case "IRON_AXE": {
                d2 = 5.0;
                break;
            }
            case "IRON_SWORD": 
            case "DIAMOND_AXE": {
                d2 = 6.0;
                break;
            }
            case "DIAMOND_SWORD": {
                d2 = 7.0;
                break;
            }
            case "STONE_SPADE": 
            case "WOOD_PICKAXE": 
            case "GOLD_PICKAXE": {
                d2 = 2.0;
                break;
            }
            case "IRON_SPADE": 
            case "STONE_PICKAXE": 
            case "WOOD_AXE": 
            case "GOLD_AXE": {
                d2 = 3.0;
                break;
            }
            default: {
                d2 = 1.0;
            }
        }
        return d2;
    }

    public boolean isSpawned() {
        return this.npc.isSpawned();
    }

    public void destroy(boolean fast) {
        if (!Bukkit.isPrimaryThread()) {
            new /* Unavailable Anonymous Inner Class!! */.runTask((Plugin)StrikePractice.getInstance());
        }
        this.npc.despawn(DespawnReason.PLUGIN);
        if (fast || StrikePractice.getInstance().getConfig().getBoolean("bot-fast-destroy")) {
            if (this.getBukkitEntity() != null) {
                this.getBukkitEntity().setHealth(20.0);
            }
            this.npc.destroy();
            this.destroyed = true;
            npcs.remove(this);
            this.npc = null;
            try {
                if (!(StrikePractice.disabling && this.plugin.getConfig().getBoolean("no-bot-kick-on-stop") || this.plugin.getConfig().getBoolean("no-bot-kick"))) {
                    this.getBukkitEntity().kickPlayer("kicking buggy bot");
                    Bukkit.getLogger().info("Set no-bot-kick: true or no-bot-kick-on-stop: true to disable this (e.g if it causes issues)");
                }
            }
            catch (Exception exception) {}
        } else {
            this.destroy();
        }
    }

    @Override
    public void destroy() {
        if (this.combatTask != null) {
            this.combatTask.killed = true;
        }
        if (!this.destroyed) {
            Location loc = this.getBukkitEntity() != null ? this.getBukkitEntity().getLocation() : this.plugin.practice.getLobby();
            this.teleport(loc.subtract(0.0, 100.0, 0.0));
            new /* Unavailable Anonymous Inner Class!! */.runTaskLater((Plugin)this.plugin, 15L);
        }
    }

    @Override
    public boolean isLegacy() {
        return true;
    }

    public void swingMainArm() {
        if (this.getBukkitEntity() != null) {
            try {
                PlayerAnimation.ARM_SWING.play(this.getBukkitEntity());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (VersionUtil.IS_13_PLUS && !Bukkit.isPrimaryThread()) {
                new /* Unavailable Anonymous Inner Class!! */.runTask((Plugin)StrikePractice.getInstance());
            } else {
                Bukkit.getPluginManager().callEvent((Event)new PlayerAnimationEvent(this.getBukkitEntity()));
            }
        }
    }

    public void hurt(Damage damage) {
        this.getBukkitEntity().playEffect(EntityEffect.HURT);
        for (Entity ent : this.getBukkitEntity().getNearbyEntities(100.0, 100.0, 100.0)) {
            if (!(ent instanceof Player)) continue;
            SoundManager.playSound((Player)((Player)ent), (Location)this.getBukkitEntity().getLocation(), (String)"HURT_FLESH", (float)0.7f, (float)1.0f);
        }
        if (damage.isBurn()) {
            this.getBukkitEntity().setFireTicks(80);
        }
        try {
            Location l2 = this.getBukkitEntity().getLocation().add(0.0, 1.0, 0.0);
            StrikePractice.getInstance().getNMSAccessProvider().getAccess().playDamageEffect(damage, l2);
        }
        catch (Error error) {
            // empty catch block
        }
    }

    public void setVelocity(Vector v2) {
        if (this.npc != null && !this.destroyed) {
            this.getBukkitEntity().setVelocity(v2);
        }
    }

    public boolean teleport(Location loc) {
        if (loc == null || this.getBukkitEntity() == null) {
            return false;
        }
        if (teleportFix && (this.errorTeleport(loc) || this.errorTeleport(this.getBukkitEntity().getLocation()))) {
            return false;
        }
        if (!loc.getChunk().isLoaded()) {
            loc.getChunk().load();
        }
        try {
            try {
                this.npc.getNavigator().setTarget((Location)null);
                this.npc.getNavigator().setPaused(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.npc.teleport(loc, PlayerTeleportEvent.TeleportCause.PLUGIN);
            CitizensNPC.assumePose((Entity)this.getBukkitEntity(), loc.getYaw(), loc.getPitch());
            return true;
        }
        catch (Exception e2) {
            Bukkit.getLogger().warning("Failed to teleport a NPC");
            return false;
        }
    }

    private boolean errorTeleport(Location loc) {
        double dist = Double.MAX_VALUE;
        for (Player p2 : loc.getWorld().getPlayers()) {
            double d2;
            if (p2.getWorld() != loc.getWorld() || !(dist > (d2 = p2.getLocation().distanceSquared(loc)))) continue;
            dist = d2;
        }
        return dist > 40000.0;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void startCombatTask(List<UUID> players, Fight fight, Difficulty difficulty) {
        this.combatTask = new CombatTask(this, players, fight, difficulty);
    }

    public void startCombatTask(List<UUID> players, Fight fight, Difficulty difficulty, BattleKit kit) {
        this.combatTask = new CombatTask(this, players, fight, difficulty, kit);
    }

    public static void assumePose(Entity entity, float yaw, float pitch) {
        block2: {
            try {
                NMS.look((Entity)entity, (float)yaw, (float)pitch);
            }
            catch (Exception e2) {
                if (!SPDebugger.getDEBUG()) break block2;
                SPDebugger.debug((String)"Failed to assume pose (bots)");
                e2.printStackTrace();
            }
        }
    }

    static /* synthetic */ NPC access$000(CitizensNPC x0) {
        return x0.npc;
    }

    static /* synthetic */ NPC access$100(CitizensNPC x0) {
        return x0.npc;
    }

    @APIClass
    public static enum Difficulty {
        EASY,
        NORMAL,
        HARD,
        HACKER,
        CUSTOM;

        private final String displayName;
        private final ItemStack icon;
        private final double reach;

        private Difficulty() {
            StrikePractice plugin = StrikePractice.getInstance();
            this.icon = ItemFlagUtil.tryAddingHidingFlags((ItemStack)plugin.getConfig().getItemStack("bot-difficulty." + this.name().toLowerCase() + ".icon"));
            this.reach = plugin.getConfig().getDouble("bot-difficulty." + this.name().toLowerCase() + ".reach");
            this.displayName = this.icon != null ? (this.icon.hasItemMeta() && this.icon.getItemMeta().hasDisplayName() ? this.icon.getItemMeta().getDisplayName() : this.name()) : this.name();
        }

        public String getDisplayName() {
            return this.displayName != null ? this.displayName : this.toString();
        }

        public double getReach() {
            return this.reach;
        }

        public ItemStack getIcon() {
            return this.icon;
        }

        public static Difficulty of(String value) {
            try {
                return Difficulty.valueOf(value.toUpperCase(Locale.ENGLISH));
            }
            catch (Exception e2) {
                return CUSTOM;
            }
        }
    }
}

