/*
 * Decompiled with CFR 0.152.
 */
package ga.strikepractice.matchrecorder.replay;

import ga.strikepractice.StrikePractice;
import ga.strikepractice.api.APIClass;
import ga.strikepractice.arena.Arena;
import ga.strikepractice.battlekit.BattleKit;
import ga.strikepractice.fightinventory.FightInventory;
import ga.strikepractice.fights.AbstractFight;
import ga.strikepractice.matchrecorder.RecordedMatch;
import ga.strikepractice.matchrecorder.RecordedPlayer;
import ga.strikepractice.matchrecorder.replay.PlayerPlaybackPlayer;
import ga.strikepractice.matchrecorder.replay.ReplayStarter;
import ga.strikepractice.npc.CitizensNPC;
import ga.strikepractice.utils.Teleporter;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;

@APIClass
public class ReplayFight
extends AbstractFight {
    private boolean ended;
    public Set<UUID> spectators = new HashSet<UUID>();
    private final HashSet<PlayerPlaybackPlayer> playbackPlayers = new HashSet();
    private List<RecordedPlayer> recordedPlayers;
    public ReplayStarter replayStarter;
    private final int killCamSeconds;

    public ReplayFight(List<RecordedPlayer> recordedPlayers, ReplayStarter replayStarter, BattleKit kit, Arena arena, int killCamSeconds) {
        super.setKit(kit);
        this.arena = arena;
        this.killCamSeconds = killCamSeconds;
        this.recordedPlayers = recordedPlayers;
        this.replayStarter = replayStarter;
    }

    @Override
    public void start() {
        this.arena.setUsing(true, this);
        String nameFormat = StrikePractice.getInstance().getConfig().getString("playback-bot-name");
        for (RecordedPlayer rp : this.recordedPlayers) {
            String name = nameFormat.replace("<player>", rp.getName());
            CitizensNPC npc = new CitizensNPC(name, rp.getName(), this.arena.getCenter());
            npc.getNPC().setProtected(true);
            PlayerPlaybackPlayer playbackPlayer = new PlayerPlaybackPlayer(rp, npc, this, this.killCamSeconds);
            playbackPlayer.start();
            this.playbackPlayers.add(playbackPlayer);
        }
    }

    public void sendFIMessages(List<FightInventory> fightInventories, UUID playbackUUID) {
        if (!fightInventories.isEmpty()) {
            for (UUID uuid : this.spectators) {
                Player p2 = Bukkit.getPlayer((UUID)uuid);
                if (p2 == null) continue;
                FightInventory.inventoryMessage(p2, fightInventories);
            }
        }
    }

    @Override
    public boolean allowSpectating() {
        return false;
    }

    @Override
    public boolean hasEnded() {
        return this.ended;
    }

    @Override
    public boolean canStart() {
        return this.arena != null && !this.arena.needsRollback() && !this.arena.isUsing() && this.arena.getLoc1() != null && this.arena.getLoc2() != null && !this.arena.getName().equalsIgnoreCase("brackets") && this.arena.getLoc1().getWorld() != null && this.arena.getLoc1().getWorld().getName().equals(this.arena.getLoc2().getWorld().getName());
    }

    @Override
    public void handleDeath(Player p2) {
    }

    public void handleRecordEnd(PlayerPlaybackPlayer playbackPlayer) {
        if (this.ended) {
            return;
        }
        boolean playing = false;
        for (PlayerPlaybackPlayer p2 : this.playbackPlayers) {
            if (!p2.isPlaying()) continue;
            playing = true;
        }
        if (!playing) {
            this.replayStarter.stopPlayback(this);
            this.arena.setUsing(false, null);
            this.ended = true;
        }
    }

    @Override
    public void forceEnd(String reason) {
        this.ended = true;
        ((AbstractFight)this).ended = System.currentTimeMillis();
        if (this.arena.isUsing()) {
            this.arena.setUsing(false, null);
        }
        for (PlayerPlaybackPlayer p2 : this.playbackPlayers) {
            if (p2.getNPC() == null || p2.getNPC().isDestroyed()) continue;
            p2.getNPC().destroy();
        }
    }

    public void addSpectator(Player p2) {
        this.spectators.add(p2.getUniqueId());
        Teleporter.teleport((Player)p2, (Location)this.arena.getCenter());
        StrikePractice.getInstance().getSpectatorHandler().addSpectator(p2);
    }

    public void removeSpectator(Player p2, boolean stop) {
        this.spectators.remove(p2.getUniqueId());
        if (this.spectators.size() == 0 && !this.hasEnded() && stop) {
            this.replayStarter.stopPlayback(this);
        }
    }

    public static void removeSpectator(Player p2) {
        for (HashSet<ReplayFight> fights : RecordedMatch.fights.values()) {
            for (ReplayFight fight : fights) {
                fight.removeSpectator(p2, true);
            }
        }
        if (StrikePractice.getInstance().getSpectatorHandler().isSpectator(p2)) {
            StrikePractice.getInstance().getSpectatorHandler().removeSpectator(p2, true);
        }
    }

    public ReplayStarter getPlaybackStarter() {
        return this.replayStarter;
    }

    public HashSet<PlayerPlaybackPlayer> getPlaybackPlayers() {
        return this.playbackPlayers;
    }

    public List<RecordedPlayer> getRecordedPlayers() {
        return this.recordedPlayers;
    }

    public void setRecordedPlayers(List<RecordedPlayer> recordedPlayers) {
        this.recordedPlayers = recordedPlayers;
    }

    @Override
    public List<String> getOpponents(Player p2) {
        return Collections.emptyList();
    }

    @Override
    public List<String> getTeammates(Player p2) {
        return Collections.emptyList();
    }

    public void setEnded(boolean ended) {
        this.ended = ended;
    }
}

