/*
 * Decompiled with CFR 0.152.
 */
package ga.strikepractice.matchrecorder;

import ga.strikepractice.api.APIClass;
import ga.strikepractice.matchrecorder.Damage;
import ga.strikepractice.matchrecorder.RecordedPlayer;
import ga.strikepractice.utils.SerializableLocation;
import ga.strikepractice.utils.SerializableProjectile;
import ga.strikepractice.utils.SimpleItem;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

/*
 * Exception performing whole class analysis ignored.
 */
@APIClass
@SerializableAs(value="RecordedPlayer")
public class RecordedPlayer
implements ConfigurationSerializable {
    private List<Location> locations = new ArrayList<Location>();
    private List<Vector> velocities = new ArrayList<Vector>();
    private Map<Integer, Damage> tookDamage = new HashMap<Integer, Damage>();
    private List<Integer> swung = new ArrayList<Integer>();
    private Map<Integer, Map<Location, SimpleItem>> blocksPlaced = new HashMap<Integer, Map<Location, SimpleItem>>();
    private Map<Integer, Map.Entry<Location, Integer>> blocksBroken = new HashMap<Integer, Map.Entry<Location, Integer>>();
    private Map<Integer, SimpleItem> itemsInHand = new HashMap<Integer, SimpleItem>();
    private Map<Integer, SimpleItem> helmets = new HashMap<Integer, SimpleItem>();
    private Map<Integer, SimpleItem> chestplates = new HashMap<Integer, SimpleItem>();
    private Map<Integer, SimpleItem> leggings = new HashMap<Integer, SimpleItem>();
    private Map<Integer, SimpleItem> boots = new HashMap<Integer, SimpleItem>();
    private Map<Integer, Boolean> sneaks = new HashMap<Integer, Boolean>();
    private Map<Integer, Boolean> sprints = new HashMap<Integer, Boolean>();
    private Map<Integer, SerializableProjectile> projectiles = new HashMap<Integer, SerializableProjectile>();
    private int death;
    private UUID uuid;
    private String name;
    public Map<RecordedItem, SimpleItem> quickCache = new EnumMap<RecordedItem, SimpleItem>(RecordedItem.class);

    public RecordedPlayer(UUID uuid, String name) {
        this.uuid = uuid;
        this.name = name;
        for (RecordedItem value : RecordedItem.values()) {
            this.quickCache.put(value, new SimpleItem(new ItemStack(Material.AIR)));
        }
    }

    public RecordedPlayer(Map<String, Object> serialized) {
        boolean enchanted;
        Material m2;
        int tick;
        String[] s2;
        String string;
        SerializableLocation ser;
        if (serialized == null) {
            return;
        }
        if (serialized.isEmpty()) {
            return;
        }
        if (serialized.containsKey("name") && serialized.get("name") instanceof String) {
            this.name = (String)serialized.get("name");
        }
        if (serialized.containsKey("uuid") && serialized.get("uuid") instanceof String) {
            this.uuid = UUID.fromString((String)serialized.get("uuid"));
        }
        World defaultWorld = (World)Bukkit.getWorlds().get(0);
        if (serialized.containsKey("locations") && serialized.get("locations") instanceof List) {
            for (Object o2 : (List)serialized.get("locations")) {
                if (!(o2 instanceof String)) continue;
                ser = SerializableLocation.fromString((String)((String)o2));
                ser.setWorld(defaultWorld.getName());
                this.locations.add(ser.toLocation());
            }
        }
        if (serialized.containsKey("velocities") && serialized.get("velocities") instanceof List) {
            for (Object o2 : (List)serialized.get("velocities")) {
                if (!(o2 instanceof String)) continue;
                ser = SerializableLocation.fromString((String)((String)o2));
                this.velocities.add(new Vector(ser.getX(), ser.getY(), ser.getZ()));
            }
        }
        if (serialized.containsKey("swung") && serialized.get("swung") instanceof List) {
            for (Object o2 : (List)serialized.get("swung")) {
                if (!(o2 instanceof Integer)) continue;
                this.swung.add((Integer)o2);
            }
        }
        if (serialized.containsKey("took-damage") && serialized.get("took-damage") instanceof List) {
            for (Object o2 : (List)serialized.get("took-damage")) {
                if (!(o2 instanceof String)) continue;
                String[] s3 = ((String)o2).split("-");
                if (s3.length == 2) {
                    this.tookDamage.put(Integer.parseInt(s3[0]), Damage.fromString((String)s3[1]));
                    continue;
                }
                this.tookDamage.put(Integer.parseInt((String)o2), new Damage(false, false, false));
            }
        }
        if (serialized.containsKey("blocks-placed") && serialized.get("blocks-placed") instanceof List) {
            for (Object o2 : (List)serialized.get("blocks-placed")) {
                Map<Object, Object> blocks;
                if (!(o2 instanceof String)) continue;
                string = (String)o2;
                s2 = string.split(":");
                tick = Integer.parseInt(s2[0]);
                m2 = Material.getMaterial((String)s2[1]);
                short sh = Short.parseShort(s2[2]);
                if (!this.blocksPlaced.containsKey(tick)) {
                    blocks = new HashMap<Location, SimpleItem>(1);
                    blocks.put(SerializableLocation.fromString((String)s2[3]).toLocation(), new SimpleItem(m2, sh));
                    this.blocksPlaced.put(tick, blocks);
                    continue;
                }
                blocks = this.blocksPlaced.get(tick);
                blocks.put(SerializableLocation.fromString((String)s2[3]).toLocation(), new SimpleItem(m2, sh));
                this.blocksPlaced.put(tick, blocks);
            }
        }
        if (serialized.containsKey("blocks-broken") && serialized.get("blocks-broken") instanceof List) {
            for (Object o2 : (List)serialized.get("blocks-broken")) {
                if (!(o2 instanceof String)) continue;
                string = (String)o2;
                s2 = string.split(":");
                this.blocksBroken.put(Integer.parseInt(s2[0]), new AbstractMap.SimpleEntry<Location, Integer>(SerializableLocation.fromString((String)s2[1]).toLocation(), Integer.parseInt(s2[2])));
            }
        }
        if (serialized.containsKey("hands") && serialized.get("hands") instanceof List) {
            for (Object o2 : (List)serialized.get("hands")) {
                if (!(o2 instanceof String)) continue;
                string = (String)o2;
                s2 = string.split(":");
                tick = Integer.parseInt(s2[0]);
                m2 = Material.getMaterial((String)s2[1]);
                enchanted = Boolean.parseBoolean(s2[2]);
                this.itemsInHand.put(tick, new SimpleItem(m2, enchanted, Short.parseShort(s2[3])));
            }
        }
        if (serialized.containsKey("helmets") && serialized.get("helmets") instanceof List) {
            for (Object o2 : (List)serialized.get("helmets")) {
                if (!(o2 instanceof String)) continue;
                string = (String)o2;
                s2 = string.split(":");
                tick = Integer.parseInt(s2[0]);
                m2 = Material.getMaterial((String)s2[1]);
                enchanted = Boolean.parseBoolean(s2[2]);
                this.helmets.put(tick, new SimpleItem(m2, enchanted, Short.parseShort(s2[3])));
            }
        }
        if (serialized.containsKey("chestplates") && serialized.get("chestplates") instanceof List) {
            for (Object o2 : (List)serialized.get("chestplates")) {
                if (!(o2 instanceof String)) continue;
                string = (String)o2;
                s2 = string.split(":");
                tick = Integer.parseInt(s2[0]);
                m2 = Material.getMaterial((String)s2[1]);
                enchanted = Boolean.parseBoolean(s2[2]);
                this.chestplates.put(tick, new SimpleItem(m2, enchanted, Short.parseShort(s2[3])));
            }
        }
        if (serialized.containsKey("leggings") && serialized.get("leggings") instanceof List) {
            for (Object o2 : (List)serialized.get("leggings")) {
                if (!(o2 instanceof String)) continue;
                string = (String)o2;
                s2 = string.split(":");
                tick = Integer.parseInt(s2[0]);
                m2 = Material.getMaterial((String)s2[1]);
                enchanted = Boolean.parseBoolean(s2[2]);
                this.leggings.put(tick, new SimpleItem(m2, enchanted, Short.parseShort(s2[3])));
            }
        }
        if (serialized.containsKey("boots") && serialized.get("boots") instanceof List) {
            for (Object o2 : (List)serialized.get("boots")) {
                if (!(o2 instanceof String)) continue;
                string = (String)o2;
                s2 = string.split(":");
                tick = Integer.parseInt(s2[0]);
                m2 = Material.getMaterial((String)s2[1]);
                enchanted = Boolean.parseBoolean(s2[2]);
                this.boots.put(tick, new SimpleItem(m2, enchanted, Short.parseShort(s2[3])));
            }
        }
        if (serialized.containsKey("sneaks") && serialized.get("sneaks") instanceof List) {
            for (Object o2 : (List)serialized.get("sneaks")) {
                if (!(o2 instanceof String)) continue;
                string = (String)o2;
                s2 = string.split(":");
                tick = Integer.parseInt(s2[0]);
                boolean sneaking = Boolean.parseBoolean(s2[1]);
                this.sneaks.put(tick, sneaking);
            }
        }
        if (serialized.containsKey("sprints") && serialized.get("sprints") instanceof List) {
            for (Object o2 : (List)serialized.get("sprints")) {
                if (!(o2 instanceof String)) continue;
                string = (String)o2;
                s2 = string.split(":");
                tick = Integer.parseInt(s2[0]);
                boolean sprinting = Boolean.parseBoolean(s2[1]);
                this.sprints.put(tick, sprinting);
            }
        }
        if (serialized.containsKey("projectiles") && serialized.get("projectiles") instanceof List) {
            for (Object o2 : (List)serialized.get("projectiles")) {
                if (!(o2 instanceof SerializableProjectile)) continue;
                SerializableProjectile pr = (SerializableProjectile)o2;
                this.projectiles.put(pr.getTick(), pr);
            }
        }
        if (serialized.containsKey("death") && serialized.get("death") instanceof Integer) {
            this.death = (Integer)serialized.get("death");
        }
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> serialized = new HashMap<String, Object>();
        serialized.put("name", this.name);
        serialized.put("uuid", this.uuid.toString());
        ArrayList<String> hand = new ArrayList<String>();
        for (Map.Entry<Integer, SimpleItem> entry : this.itemsInHand.entrySet()) {
            hand.add(entry.getKey() + ":" + entry.getValue().getMaterial() + ":" + entry.getValue().isEnchanted() + ":" + entry.getValue().getDurability());
        }
        serialized.put("hands", hand);
        ArrayList<String> h2 = new ArrayList<String>();
        for (Map.Entry<Integer, SimpleItem> entry : this.helmets.entrySet()) {
            h2.add(entry.getKey() + ":" + entry.getValue().getMaterial() + ":" + entry.getValue().isEnchanted() + ":" + entry.getValue().getDurability());
        }
        serialized.put("helmets", h2);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<Integer, SimpleItem> entry : this.chestplates.entrySet()) {
            arrayList.add(entry.getKey() + ":" + entry.getValue().getMaterial() + ":" + entry.getValue().isEnchanted() + ":" + entry.getValue().getDurability());
        }
        serialized.put("chestplates", arrayList);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Map.Entry<Integer, SimpleItem> entry : this.leggings.entrySet()) {
            arrayList2.add(entry.getKey() + ":" + entry.getValue().getMaterial() + ":" + entry.getValue().isEnchanted() + ":" + entry.getValue().getDurability());
        }
        serialized.put("leggings", arrayList2);
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (Map.Entry<Integer, SimpleItem> entry : this.boots.entrySet()) {
            arrayList3.add(entry.getKey() + ":" + entry.getValue().getMaterial() + ":" + entry.getValue().isEnchanted() + ":" + entry.getValue().getDurability());
        }
        serialized.put("boots", arrayList3);
        ArrayList<String> arrayList4 = new ArrayList<String>();
        ArrayList<String> arrayList5 = new ArrayList<String>();
        for (Map.Entry<Integer, Boolean> entry : this.sneaks.entrySet()) {
            arrayList5.add(entry.getKey() + ":" + entry.getValue());
        }
        serialized.put("sneaks", arrayList5);
        ArrayList<String> sp = new ArrayList<String>();
        for (Map.Entry<Integer, Boolean> entry : this.sprints.entrySet()) {
            sp.add(entry.getKey() + ":" + entry.getValue());
        }
        serialized.put("sprints", sp);
        for (Location location : new ArrayList<Location>(this.locations)) {
            SerializableLocation serializableLocation = new SerializableLocation(location);
            serializableLocation.setWorld(null);
            arrayList4.add(serializableLocation.toString());
        }
        serialized.put("locations", arrayList4);
        serialized.put("projectiles", this.projectiles.values().toArray());
        ArrayList<String> arrayList6 = new ArrayList<String>();
        for (Vector vector : this.velocities) {
            SerializableLocation serializableLocation = new SerializableLocation(vector.toLocation(this.locations.get(0).getWorld()));
            serializableLocation.setWorld(null);
            arrayList6.add(serializableLocation.toString());
        }
        serialized.put("velocities", arrayList6);
        ArrayList<String> arrayList7 = new ArrayList<String>();
        for (Map.Entry<Integer, Map.Entry<Location, Integer>> entry : this.blocksBroken.entrySet()) {
            arrayList7.add(entry.getKey() + ":" + new SerializableLocation(entry.getValue().getKey()) + ":" + entry.getValue().getValue());
        }
        serialized.put("blocks-broken", arrayList7);
        ArrayList<String> arrayList8 = new ArrayList<String>();
        for (Map.Entry<Integer, Map<Location, SimpleItem>> entry : this.blocksPlaced.entrySet()) {
            for (Map.Entry<Location, SimpleItem> ml : entry.getValue().entrySet()) {
                String str = entry.getKey() + ":" + ml.getValue().getMaterial() + ":" + ml.getValue().getDurability() + ":" + new SerializableLocation(ml.getKey());
                arrayList8.add(str);
            }
        }
        serialized.put("blocks-placed", arrayList8);
        serialized.put("swung", this.swung);
        ArrayList<String> arrayList9 = new ArrayList<String>();
        for (Map.Entry<Integer, Damage> e2 : this.tookDamage.entrySet()) {
            arrayList9.add(e2.getKey() + "-" + e2.getValue().toString());
        }
        serialized.put("took-damage", arrayList9);
        serialized.put("death", this.death);
        return serialized;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public List<Location> getLocations() {
        return this.locations;
    }

    public Map<Integer, SerializableProjectile> getProjectiles() {
        return this.projectiles;
    }

    public void setProjectiles(Map<Integer, SerializableProjectile> projectiles) {
        this.projectiles = projectiles;
    }

    public Map<Integer, Map.Entry<Location, Integer>> getBlocksBroken() {
        return this.blocksBroken;
    }

    public void setBlocksBroken(Map<Integer, Map.Entry<Location, Integer>> blocksBroken) {
        this.blocksBroken = blocksBroken;
    }

    public void setLocations(List<Location> locations) {
        this.locations = locations;
    }

    public List<Vector> getVelocities() {
        return this.velocities;
    }

    public int getDeath() {
        return this.death;
    }

    public void setDeath(int death) {
        this.death = death;
    }

    public void setVelocities(List<Vector> velocities) {
        this.velocities = velocities;
    }

    public Map<Integer, Damage> getTookDamage() {
        return this.tookDamage;
    }

    public void setTookDamage(Map<Integer, Damage> tookDamage) {
        this.tookDamage = tookDamage;
    }

    public List<Integer> getSwung() {
        return this.swung;
    }

    public void setSwung(List<Integer> swung) {
        this.swung = swung;
    }

    public Map<Integer, Map<Location, SimpleItem>> getBlocksPlaced() {
        return this.blocksPlaced;
    }

    public void setBlocksPlaced(Map<Integer, Map<Location, SimpleItem>> blocksPlaced) {
        this.blocksPlaced = blocksPlaced;
    }

    public Map<Integer, SimpleItem> getItemsInHand() {
        return this.itemsInHand;
    }

    public void setItemInHand(Map<Integer, SimpleItem> itemInHand) {
        this.itemsInHand = itemInHand;
    }

    public Map<Integer, SimpleItem> getHelmets() {
        return this.helmets;
    }

    public void setHelmets(Map<Integer, SimpleItem> helmets) {
        this.helmets = helmets;
    }

    public Map<Integer, SimpleItem> getChestplates() {
        return this.chestplates;
    }

    public void setChestplates(Map<Integer, SimpleItem> chestplates) {
        this.chestplates = chestplates;
    }

    public Map<Integer, Boolean> getSneaks() {
        return this.sneaks;
    }

    public void setSneaks(Map<Integer, Boolean> sneaks) {
        this.sneaks = sneaks;
    }

    public Map<Integer, Boolean> getSprints() {
        return this.sprints;
    }

    public void setSprints(Map<Integer, Boolean> sprints) {
        this.sprints = sprints;
    }

    public Map<Integer, SimpleItem> getLeggings() {
        return this.leggings;
    }

    public void setLeggings(Map<Integer, SimpleItem> leggings) {
        this.leggings = leggings;
    }

    public Map<Integer, SimpleItem> getBoots() {
        return this.boots;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBoots(Map<Integer, SimpleItem> boots) {
        this.boots = boots;
    }

    public static RecordedPlayer deserialize(Map<String, Object> serialized) {
        return new RecordedPlayer(serialized);
    }

    public static RecordedPlayer valueOf(Map<String, Object> serialized) {
        return new RecordedPlayer(serialized);
    }
}

