/*
 * Decompiled with CFR 0.152.
 */
package ga.strikepractice.matchrecorder;

import ga.strikepractice.StrikePractice;
import ga.strikepractice.api.APIClass;
import ga.strikepractice.arena.Arena;
import ga.strikepractice.battlekit.BattleKit;
import ga.strikepractice.battlekit.DefaultBattleKit;
import ga.strikepractice.fightinventory.FightInventory;
import ga.strikepractice.fights.savedfights.SavedFight;
import ga.strikepractice.matchrecorder.RecordedMatchComparatorByDate;
import ga.strikepractice.matchrecorder.RecordedPlayer;
import ga.strikepractice.matchrecorder.replay.ReplayFight;
import ga.strikepractice.matchrecorder.replay.ReplayStarter;
import ga.strikepractice.matchrecorder.storage.StoredReplay;
import ga.strikepractice.utils.SPDebugger;
import ga.strikepractice.utils.Scheduler;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

@APIClass
@SerializableAs(value="RecordedMatch")
public class RecordedMatch
extends ReplayStarter
implements ConfigurationSerializable {
    public static boolean FULL_LOAD;
    public static Map<RecordedMatch, HashSet<ReplayFight>> fights;
    private List<RecordedPlayer> recordedPlayers = new ArrayList<RecordedPlayer>();
    private List<FightInventory> fightInventories = new ArrayList<FightInventory>();
    private Map<UUID, String> players;
    private Arena arena;
    private String arenaName;
    private BattleKit kit;
    private StoredReplay storedReplay;
    private String dateFormat;
    private long started;
    private long ended;
    private boolean mySQLInventories;

    public RecordedMatch(Map<UUID, String> players, BattleKit battleKit, Arena arena) {
        this.setArena(arena);
        this.kit = battleKit;
        this.players = players;
        this.started = System.currentTimeMillis();
    }

    public ReplayFight startPlayback(int killCamSeconds) {
        if (this.updateArena()) {
            this.freeMemory();
            ReplayFight replayFight = new ReplayFight(new ArrayList<RecordedPlayer>(this.recordedPlayers), this, this.kit, this.arena, killCamSeconds);
            if (replayFight.canStart()) {
                if (this.recordedPlayers.size() == 0) {
                    this.loadEverythingAsync(() -> {
                        if (this.recordedPlayers.isEmpty()) {
                            HashSet<ReplayFight> fs;
                            replayFight.forceEnd(ChatColor.RED + "The replay could not be started. The replay might be corrupted.");
                            for (UUID uuid : new ArrayList<UUID>(replayFight.spectators)) {
                                Player p2 = Bukkit.getPlayer((UUID)uuid);
                                if (p2 == null) continue;
                                ReplayFight.removeSpectator(p2);
                                p2.sendMessage(ChatColor.RED + "The replay could not be started. The replay might be corrupted.");
                            }
                            if (fights.containsKey((Object)this) && (fs = fights.get((Object)this)).remove(replayFight)) {
                                fights.put(this, fs);
                            }
                            replayFight.getArena().setUsing(false);
                        } else {
                            replayFight.setRecordedPlayers(new ArrayList<RecordedPlayer>(this.recordedPlayers));
                            replayFight.start();
                            replayFight.sendFIMessages(this.fightInventories, this.uuid);
                        }
                    });
                } else {
                    replayFight.setRecordedPlayers(new ArrayList<RecordedPlayer>(this.recordedPlayers));
                    replayFight.start();
                    replayFight.sendFIMessages(this.fightInventories, this.uuid);
                }
                HashSet<ReplayFight> fs = fights.getOrDefault((Object)this, new HashSet());
                fs.add(replayFight);
                fights.put(this, fs);
                return replayFight;
            }
        }
        return null;
    }

    public void stopPlayback(ReplayFight replayFight) {
        if (replayFight.hasEnded()) {
            return;
        }
        replayFight.setEnded(true);
        replayFight.getArena().setUsing(true);
        new /* Unavailable Anonymous Inner Class!! */.runTaskLater((Plugin)StrikePractice.getInstance(), (long)(20 * StrikePractice.getInstance().getConfig().getInt("wait-before-teleport")));
        this.freeMemory();
    }

    public boolean updateArena() {
        if (this.arena != null) {
            this.arena = this.findArena(this.arena);
            return this.arena != null && !this.arena.isUsing() && !this.arena.needsRollback();
        }
        return false;
    }

    private Arena findArena(Arena arena) {
        if (arena.getName().toLowerCase().contains("brackets") || arena.getName().equalsIgnoreCase("koth")) {
            for (Arena ar : StrikePractice.getInstance().arenas) {
                if (!ar.getName().endsWith(":" + arena.getName()) || ar.isUsing() || this.kit != null && (ar.needsRollback() || !this.kit.isBuild())) continue;
                this.arenaName = ar.getDisplayName();
                return ar;
            }
            this.arenaName = arena.getDisplayName();
            return null;
        }
        String realName = arena.getName();
        if (arena.getName().contains(":")) {
            realName = arena.getName().split(":")[1];
        }
        boolean correctBuildMode = false;
        for (Arena ar : StrikePractice.getInstance().arenas) {
            if (!ar.getName().equals(realName) && !ar.getName().endsWith(":" + realName) || arena.getName().equalsIgnoreCase("koth") || arena.getName().equalsIgnoreCase("brackets") || !ar.isBuild() && (this.kit == null || this.kit.isBuild())) continue;
            correctBuildMode = true;
            if (ar.isUsing() || ar.needsRollback()) continue;
            this.arenaName = ar.getDisplayName();
            return ar;
        }
        if (!correctBuildMode) {
            for (Arena ar : StrikePractice.getInstance().arenas) {
                if (!ar.getName().equals(realName) && !ar.getName().endsWith(":" + realName) || arena.getName().equalsIgnoreCase("koth") || arena.getName().equalsIgnoreCase("brackets") || ar.isUsing() || ar.needsRollback()) continue;
                this.arenaName = ar.getDisplayName();
                return ar;
            }
        }
        this.arenaName = arena.getDisplayName();
        return arena;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadEverything() {
        FULL_LOAD = true;
        this.getStoredMatch().reloadFromStorage();
        RecordedMatch rm = (RecordedMatch)((Object)this.getStoredMatch().getConfig().get("match"));
        this.recordedPlayers = rm.getRecordedPlayers();
        if (this.mySQLInventories) {
            if (!this.fightInventories.isEmpty() || !StrikePractice.getInstance().getConfig().getBoolean("save-elo-fights") && (!StrikePractice.getInstance().getConfig().getBoolean("save-all-fights") || !StrikePractice.getInstance().isMySQL)) return;
            try {
                SavedFight sf = SavedFight.byReplayId(this.getUUID());
                if (sf == null) return;
                for (FightInventory inv : sf.getLosersInventories()) {
                    inv.save();
                    this.fightInventories.add(inv);
                }
                for (FightInventory inv : sf.getWinnersInventories()) {
                    inv.save();
                    this.fightInventories.add(inv);
                }
                return;
            }
            catch (Exception e2) {
                Bukkit.getLogger().info("Failed to load fight inventories... this is harmless");
                e2.printStackTrace();
                return;
            }
        } else {
            this.fightInventories = rm.getFightInventories();
        }
    }

    public void loadEverythingAsync(Runnable callback) {
        Scheduler.async(() -> {
            this.loadEverything();
            Bukkit.getScheduler().runTask((Plugin)StrikePractice.getInstance(), callback);
        });
    }

    public RecordedMatch(Map<String, Object> serialized) {
        this.load(serialized);
    }

    private void load(Map<String, Object> serialized) {
        Object list;
        if (serialized == null) {
            return;
        }
        if (serialized.isEmpty()) {
            return;
        }
        if (serialized.containsKey("started") && serialized.get("started") instanceof Long) {
            this.started = (Long)serialized.get("started");
        }
        if (serialized.containsKey("ended") && serialized.get("ended") instanceof Long) {
            this.ended = (Long)serialized.get("ended");
        }
        if (serialized.containsKey("arena") && serialized.get("arena") instanceof String) {
            this.setArena((String)serialized.get("arena"));
        }
        if (serialized.containsKey("match-uuid") && serialized.get("match-uuid") instanceof String) {
            this.uuid = UUID.fromString((String)serialized.get("match-uuid"));
        }
        if (serialized.containsKey("kit") && serialized.get("kit") instanceof String) {
            String kit = (String)serialized.get("kit");
            for (BattleKit k2 : StrikePractice.getInstance().kits) {
                if (!k2.getName().equals(kit)) continue;
                this.kit = k2;
            }
            if (this.kit == null) {
                this.kit = new DefaultBattleKit("Unknown Kit");
            }
        }
        if (FULL_LOAD && serialized.containsKey("fight-inventories") && serialized.get("fight-inventories") instanceof List) {
            for (Object o2 : (List)serialized.get("fight-inventories")) {
                if (!(o2 instanceof String)) continue;
                this.fightInventories.add(FightInventory.fromLegacyString((String)o2));
            }
        } else if (StrikePractice.getInstance().getConfig().getBoolean("save-elo-fights") && this.kit.isElo() || StrikePractice.getInstance().getConfig().getBoolean("save-all-fights")) {
            this.mySQLInventories = true;
        }
        this.players = new HashMap<UUID, String>();
        if (serialized.containsKey("activity") && (list = serialized.get("activity")) instanceof List) {
            for (BattleKit o3 : (List)list) {
                if (!(o3 instanceof RecordedPlayer)) continue;
                RecordedPlayer rec = (RecordedPlayer)((Object)o3);
                this.recordedPlayers.add(rec);
                this.players.put(rec.getUuid(), rec.getName());
            }
        }
        if (!FULL_LOAD) {
            this.recordedPlayers.clear();
        }
    }

    public void freeMemory() {
        this.recordedPlayers.clear();
        this.fightInventories.clear();
        this.storedReplay = null;
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> serialized = new HashMap<String, Object>();
        serialized.put("arena", this.arena.getName());
        serialized.put("kit", this.kit.getName());
        serialized.put("match-uuid", this.getUUID().toString());
        serialized.put("started", this.started);
        serialized.put("ended", this.ended);
        serialized.put("activity", this.recordedPlayers);
        if (this.fightInventories != null && this.fightInventories.isEmpty()) {
            if (StrikePractice.getInstance().getConfig().getBoolean("save-elo-fights") && this.kit.isElo() || StrikePractice.getInstance().getConfig().getBoolean("save-all-fights")) {
                return serialized;
            }
            ArrayList<String> fis = new ArrayList<String>();
            for (FightInventory fi : this.fightInventories) {
                fis.add(fi.toLegacyString());
            }
            serialized.put("fight-inventories", fis);
        }
        return serialized;
    }

    public static RecordedMatch deserialize(Map<String, Object> serialized) {
        return new RecordedMatch(serialized);
    }

    public void saveToStorage(boolean async) {
        this.ended = System.currentTimeMillis();
        if (async) {
            Scheduler.async(() -> this.saveToStorage(false));
        } else {
            SPDebugger.debug((String)("Saving replay " + this.getUUID()));
            StoredReplay storedMatch = this.getStoredMatch();
            storedMatch.getConfig().set("match", (Object)this);
            storedMatch.save();
            for (UUID uuid : this.players.keySet()) {
                List<RecordedMatch> rec = StrikePractice.getInstance().getRecordedMatchesManager().getRecordedDuels().containsKey(uuid) ? (List)StrikePractice.getInstance().getRecordedMatchesManager().getRecordedDuels().get(uuid) : new ArrayList<RecordedMatch>();
                rec.add(this);
                rec.sort((Comparator<RecordedMatch>)new RecordedMatchComparatorByDate());
                StrikePractice.getInstance().getRecordedMatchesManager().getRecordedDuels().put(uuid, rec);
            }
            this.freeMemory();
        }
    }

    public List<FightInventory> getFightInventories() {
        return this.fightInventories;
    }

    public void setFightInventories(List<FightInventory> fightInventories) {
        this.fightInventories = fightInventories;
    }

    public List<RecordedPlayer> getRecordedPlayers() {
        return this.recordedPlayers;
    }

    public void setRecordedPlayers(ArrayList<RecordedPlayer> recordedPlayers) {
        this.recordedPlayers = recordedPlayers;
    }

    public Map<UUID, String> getPlayers() {
        return this.players;
    }

    public void setPlayers(Map<UUID, String> players) {
        this.players = players;
    }

    public BattleKit getKit() {
        return this.kit;
    }

    public void setKit(BattleKit kit) {
        this.kit = kit;
    }

    public long getStarted() {
        return this.started;
    }

    public void setStarted(long started) {
        this.started = started;
    }

    public long getEnded() {
        return this.ended;
    }

    public void setEnded(long ended) {
        this.ended = ended;
    }

    public String getDateFormat() {
        if (this.dateFormat == null) {
            SimpleDateFormat df = new SimpleDateFormat(StrikePractice.getInstance().getConfig().getString("date-format"));
            this.dateFormat = df.format(new Date(this.started));
        }
        return this.dateFormat;
    }

    public Arena getArena() {
        return this.arena;
    }

    public String getArenaName() {
        return this.arenaName;
    }

    public void setArena(Arena arena) {
        if (this.setArena(arena.getName()) == null) {
            this.arena = arena;
        }
    }

    public Arena setArena(String arena) {
        if (arena.contains(":") && arena.split(":").length > 1) {
            String realName = arena.split(":")[1];
            for (Arena a2 : StrikePractice.getInstance().arenas) {
                if (!a2.getName().equals(realName)) continue;
                this.arenaName = a2.getDisplayName();
                this.arena = a2;
                return this.arena;
            }
        }
        for (Arena a3 : StrikePractice.getInstance().arenas) {
            if (!a3.getName().equals(arena)) continue;
            this.arenaName = a3.getDisplayName();
            this.arena = a3;
            return this.arena;
        }
        this.arena = null;
        return null;
    }

    public StoredReplay getStoredMatch() {
        if (this.storedReplay == null) {
            this.storedReplay = StoredReplay.create((RecordedMatch)this);
        }
        return this.storedReplay;
    }

    static {
        fights = new HashMap<RecordedMatch, HashSet<ReplayFight>>();
    }
}

