/*
 * Decompiled with CFR 0.152.
 */
package ga.strikepractice.hostedevents;

import ga.strikepractice.api.APIClass;
import ga.strikepractice.battlekit.BattleKit;
import ga.strikepractice.hostedevents.PvPEvent;
import ga.strikepractice.hostedevents.brackets.BracketsCommand;
import ga.strikepractice.hostedevents.juggernaut.JuggernautCommand;
import ga.strikepractice.hostedevents.koth.KOTHCommand;
import ga.strikepractice.hostedevents.lms.LMSCommand;
import ga.strikepractice.hostedevents.sumo.SumoCommand;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;

@APIClass
public interface PvPEvent {
    public void start();

    public void stop();

    public boolean hasStarted();

    public BattleKit getKit();

    public static boolean isInEvent(Player p2) {
        if (LMSCommand.lms != null && LMSCommand.lms.getAlive().contains(p2.getName())) {
            return true;
        }
        if (p2.hasMetadata("ToppeBattlesLmsWaiting")) {
            return true;
        }
        if (p2.hasMetadata("StrikePracticeJuggernaut")) {
            return true;
        }
        if (JuggernautCommand.juggernaut != null && JuggernautCommand.juggernaut.getJuggernaut() != null && JuggernautCommand.juggernaut.getJuggernaut().equalsIgnoreCase(p2.getName())) {
            return true;
        }
        if (BracketsCommand.brackets != null && BracketsCommand.brackets.getPlayers().containsKey(p2.getName())) {
            return true;
        }
        if (SumoCommand.sumo != null && SumoCommand.sumo.getPlayers().containsKey(p2.getName())) {
            return true;
        }
        if (KOTHCommand.joined.contains(p2.getUniqueId())) {
            return true;
        }
        return KOTHCommand.koth != null && (KOTHCommand.koth.getTeam1().getMembers().contains(p2.getUniqueId()) || KOTHCommand.koth.getTeam2().getMembers().contains(p2.getUniqueId()));
    }

    public static String getEventString(Player p2) {
        if (LMSCommand.lms != null && LMSCommand.lms.getAlive().contains(p2.getName())) {
            return "lms (alive)";
        }
        if (p2.hasMetadata("ToppeBattlesLmsWaiting")) {
            return "lms (waiting)";
        }
        if (p2.hasMetadata("StrikePracticeJuggernaut")) {
            return "juggernaut (joined)";
        }
        if (JuggernautCommand.juggernaut != null && JuggernautCommand.juggernaut.getJuggernaut() != null && JuggernautCommand.juggernaut.getJuggernaut().equalsIgnoreCase(p2.getName())) {
            return "juggernaut (the juggernaut)";
        }
        if (BracketsCommand.brackets != null && BracketsCommand.brackets.getPlayers().containsKey(p2.getName())) {
            return "brackets";
        }
        if (SumoCommand.sumo != null && SumoCommand.sumo.getPlayers().containsKey(p2.getName())) {
            return "sumo";
        }
        if (KOTHCommand.joined.contains(p2.getUniqueId())) {
            return "koth (waiting)";
        }
        if (KOTHCommand.koth != null && (KOTHCommand.koth.getTeam1().getMembers().contains(p2.getUniqueId()) || KOTHCommand.koth.getTeam2().getMembers().contains(p2.getUniqueId()))) {
            return "koth";
        }
        return "not in event";
    }

    public static PvPEvent getEvent(Player p2) {
        if (LMSCommand.lms != null && LMSCommand.lms.getAlive().contains(p2.getName())) {
            return LMSCommand.lms;
        }
        if (JuggernautCommand.juggernaut != null && p2.hasMetadata("StrikePracticeJuggernaut")) {
            return JuggernautCommand.juggernaut;
        }
        if (JuggernautCommand.juggernaut != null && JuggernautCommand.juggernaut.getJuggernaut() != null && JuggernautCommand.juggernaut.getJuggernaut().equals(p2.getName())) {
            return JuggernautCommand.juggernaut;
        }
        if (BracketsCommand.brackets != null && BracketsCommand.brackets.getPlayers().containsKey(p2.getName())) {
            return BracketsCommand.brackets;
        }
        if (SumoCommand.sumo != null && SumoCommand.sumo.getPlayers().containsKey(p2.getName())) {
            return SumoCommand.sumo;
        }
        if (KOTHCommand.joined.contains(p2.getUniqueId())) {
            return KOTHCommand.koth;
        }
        if (KOTHCommand.koth != null && (KOTHCommand.koth.getTeam1().getMembers().contains(p2.getUniqueId()) || KOTHCommand.koth.getTeam2().getMembers().contains(p2.getUniqueId()))) {
            return KOTHCommand.koth;
        }
        return null;
    }

    public static List<PvPEvent> getCurrentPvPEvents() {
        ArrayList<PvPEvent> events = new ArrayList<PvPEvent>();
        if (LMSCommand.lms != null && LMSCommand.lms.hasStarted()) {
            events.add((PvPEvent)LMSCommand.lms);
        }
        if (JuggernautCommand.juggernaut != null && JuggernautCommand.juggernaut.hasStarted()) {
            events.add((PvPEvent)JuggernautCommand.juggernaut);
        }
        if (BracketsCommand.brackets != null && BracketsCommand.brackets.hasStarted()) {
            events.add((PvPEvent)BracketsCommand.brackets);
        }
        if (KOTHCommand.koth != null && KOTHCommand.koth.hasStarted()) {
            events.add((PvPEvent)KOTHCommand.koth);
        }
        if (SumoCommand.sumo != null && SumoCommand.sumo.hasStarted()) {
            events.add((PvPEvent)SumoCommand.sumo);
        }
        return events;
    }

    public long getStartTime();

    default public long getPhaseDuration() {
        return System.currentTimeMillis() - this.getStartTime();
    }

    public int getPlayersLeft();

    public int getTotalPlayers();

    public PvPEventType getType();
}

