/*
 * Decompiled with CFR 0.152.
 */
package ga.strikepractice.fights.requests;

import ga.strikepractice.StrikePractice;
import ga.strikepractice.api.APIClass;
import ga.strikepractice.fights.Fight;
import ga.strikepractice.fights.requests.DuelRequest;
import ga.strikepractice.fights.requests.PartyVsPartyRequest;
import java.util.Collection;
import java.util.HashSet;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.metadata.Metadatable;
import org.bukkit.plugin.Plugin;

@APIClass
public interface FightRequest {
    public static final String DUEL_REQUEST = "SPDuelRequest";
    public static final String PARTY_REQUESTS = "SPPartyRequest";

    public static void addDuelRequest(Player p2, DuelRequest request) {
        Collection<DuelRequest> requests = FightRequest.getDuelRequestsForPlayer(p2);
        requests.removeIf(req -> req.hasExpired() || request.getDueler().equals(req.getDueler()));
        requests.add(request);
    }

    public static Collection<DuelRequest> getDuelRequestsForPlayer(Player p2) {
        MetadataValue m2 = StrikePractice.getInstance().getMetadata((Metadatable)p2, DUEL_REQUEST);
        if (m2 != null && m2.value() != null && m2.value() instanceof Collection) {
            return (Collection)m2.value();
        }
        HashSet<DuelRequest> set = new HashSet<DuelRequest>(2);
        p2.setMetadata(DUEL_REQUEST, (MetadataValue)new FixedMetadataValue((Plugin)StrikePractice.getInstance(), set));
        return set;
    }

    public static void addPartyRequest(Player p2, PartyVsPartyRequest partyVsPartyRequest) {
        Collection<PartyVsPartyRequest> requests = FightRequest.getPartyRequestsForPlayer(p2);
        requests.removeIf(req -> req.hasExpired() || req.getDueler() == partyVsPartyRequest.getDueler());
        requests.add(partyVsPartyRequest);
    }

    public static Collection<PartyVsPartyRequest> getPartyRequestsForPlayer(Player p2) {
        MetadataValue m2 = StrikePractice.getInstance().getMetadata((Metadatable)p2, PARTY_REQUESTS);
        if (m2 != null && m2.value() != null && m2.value() instanceof Collection) {
            return (Collection)m2.value();
        }
        HashSet<PartyVsPartyRequest> requests = new HashSet<PartyVsPartyRequest>(2);
        p2.setMetadata(PARTY_REQUESTS, (MetadataValue)new FixedMetadataValue((Plugin)StrikePractice.getInstance(), requests));
        return requests;
    }

    public static void clearAll(Player p2) {
        p2.removeMetadata(DUEL_REQUEST, (Plugin)StrikePractice.getInstance());
        p2.removeMetadata(PARTY_REQUESTS, (Plugin)StrikePractice.getInstance());
    }

    public boolean hasExpired();

    public Fight getFight();
}

