/*
 * Decompiled with CFR 0.152.
 */
package ga.strikepractice.fights.queue;

import ga.strikepractice.StrikePractice;
import ga.strikepractice.api.APIClass;
import ga.strikepractice.battlekit.BattleKit;
import ga.strikepractice.fights.AbstractFight;
import ga.strikepractice.fights.queue.QueueManager;
import ga.strikepractice.fights.queue.QueueRunnable;
import ga.strikepractice.fights.queue.QueueRunner;
import ga.strikepractice.stats.DefaultPlayerStats;
import ga.strikepractice.utils.MapUtil;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.metadata.Metadatable;
import org.bukkit.plugin.Plugin;

@APIClass
public class DuelQueueRunnable
implements QueueRunnable {
    public static final String RANKED_QUEUE = "StrikePracticeRankedQueue";
    private final StrikePractice plugin;
    private final int currentElo;
    private boolean anyone;
    private final boolean premium;
    private int counter;
    private final BattleKit kit;
    private final UUID uuid;
    private WeakReference<Player> player;
    private int range;
    private final int anyoneAfter;
    private final int eloRangeTime;
    private final int rangeIncrease;

    public DuelQueueRunnable(StrikePractice plugin, Player p2, BattleKit kit, boolean premium) {
        this.uuid = p2.getUniqueId();
        this.plugin = plugin;
        this.kit = kit;
        this.premium = premium;
        this.currentElo = DefaultPlayerStats.getStats((UUID)this.uuid).getElo(kit);
        this.player = new WeakReference<Player>(p2);
        p2.setMetadata(RANKED_QUEUE, (MetadataValue)new FixedMetadataValue((Plugin)plugin, (Object)this));
        this.range = plugin.getConfig().getInt("ranked.elo-range-increase");
        this.anyoneAfter = this.plugin.getConfig().getInt("ranked.anyone-after");
        this.eloRangeTime = this.plugin.getConfig().getInt("ranked.elo-range-time");
        this.rangeIncrease = this.plugin.getConfig().getInt("ranked.elo-range-increase");
    }

    @Override
    public void run() {
        Player p2 = this.getPlayer();
        ++this.counter;
        if (this.counter >= this.anyoneAfter) {
            if (!this.anyone) {
                this.plugin.sendMessage(p2, "ranked-anyone");
            }
            this.anyone = true;
        } else {
            DuelQueueRunnable opponent = this.checkQueue();
            if (opponent != null) {
                QueueRunner.removeQueue((QueueRunnable)opponent);
                QueueRunner.removeQueue((QueueRunnable)this);
                QueueManager.updateQueueViews();
            } else if (this.counter % this.eloRangeTime == 0) {
                this.range += this.rangeIncrease;
                this.plugin.sendMessage(p2, "ranked-range", MapUtil.mapOf((Object[])new Object[]{"<range1>", this.getFromRange(), "<range2>", this.getToRange()}));
            }
        }
    }

    private DuelQueueRunnable checkQueue() {
        Player p2 = this.getPlayer();
        for (DuelQueueRunnable qr : (Collection)QueueManager.ranked.get(this.kit)) {
            Player p22;
            if (qr == this || (p22 = qr.getPlayer()) == null || qr.getKit() != this.kit || qr.premium != this.premium || (Math.abs(qr.getCurrentElo() - this.getCurrentElo()) >= this.range || Math.abs(qr.getCurrentElo() - this.getCurrentElo()) >= qr.getRange()) && (!qr.isAnyone() || !this.anyone) || !qr.isValidQueue() || !this.isValidQueue()) continue;
            p22.removeMetadata(RANKED_QUEUE, (Plugin)this.plugin);
            p2.removeMetadata(RANKED_QUEUE, (Plugin)this.plugin);
            p22.removeMetadata("StrikePracticeWaitingQueue", (Plugin)this.plugin);
            p2.removeMetadata("StrikePracticeWaitingQueue", (Plugin)this.plugin);
            new /* Unavailable Anonymous Inner Class!! */.runTaskLater((Plugin)this.plugin, 5L);
            return qr;
        }
        return null;
    }

    public static DuelQueueRunnable getRanked(Player p2) {
        MetadataValue mv = StrikePractice.getInstance().getMetadata((Metadatable)p2, RANKED_QUEUE);
        if (mv != null && mv.value() instanceof DuelQueueRunnable) {
            return (DuelQueueRunnable)mv.value();
        }
        return null;
    }

    public Player getPlayer() {
        if (this.player == null) {
            this.player = new WeakReference<Player>(Bukkit.getPlayer((UUID)this.getUUID()));
        }
        return (Player)this.player.get();
    }

    @Override
    public boolean isValidQueue() {
        return this.getPlayer() != null && DuelQueueRunnable.getRanked(this.getPlayer()) == this && AbstractFight.getCurrentFight(this.getPlayer()) == null;
    }

    @Override
    public int getCurrentElo() {
        return this.currentElo;
    }

    public boolean isPremium() {
        return this.premium;
    }

    @Override
    public int getRange() {
        return this.range;
    }

    @Override
    public BattleKit getKit() {
        return this.kit;
    }

    @Override
    public void setRange(int range) {
        this.range = range;
    }

    @Override
    public boolean isAnyone() {
        return this.anyone;
    }

    @Override
    public void setAnyone(boolean anyone) {
        this.anyone = anyone;
    }

    @Override
    public int getCounter() {
        return this.counter;
    }

    @Override
    public void setCounter(int counter) {
        this.counter = counter;
    }

    @Override
    public int getFromRange() {
        return Math.max(0, this.currentElo - this.range);
    }

    @Override
    public int getToRange() {
        return this.currentElo + this.range;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    static /* synthetic */ BattleKit access$000(DuelQueueRunnable x0) {
        return x0.kit;
    }

    static /* synthetic */ StrikePractice access$100(DuelQueueRunnable x0) {
        return x0.plugin;
    }

    static /* synthetic */ boolean access$200(DuelQueueRunnable x0) {
        return x0.premium;
    }
}

