/*
 * Decompiled with CFR 0.152.
 */
package ga.strikepractice.fights.party.partyfights.partyqueue;

import ga.strikepractice.StrikePractice;
import ga.strikepractice.api.APIClass;
import ga.strikepractice.battlekit.BattleKit;
import ga.strikepractice.fights.AbstractFight;
import ga.strikepractice.fights.party.partyfights.partyqueue.PartyQueueManager;
import ga.strikepractice.fights.queue.QueueRunnable;
import ga.strikepractice.fights.queue.QueueRunner;
import ga.strikepractice.hostedevents.PvPEvent;
import ga.strikepractice.party.Party;
import ga.strikepractice.stats.DefaultPlayerStats;
import ga.strikepractice.utils.MapUtil;
import ga.strikepractice.utils.PlayerInventory;
import java.util.Collection;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.metadata.Metadatable;
import org.bukkit.plugin.Plugin;

@APIClass
public class PartyQueueRunnable
implements QueueRunnable {
    public static final String RANKED_QUEUE = "StrikePractice2v2RankedQueue";
    private final StrikePractice plugin;
    private final int currentElo;
    private int range;
    private boolean anyone;
    private int counter;
    private final BattleKit kit;
    private final Party party;

    public PartyQueueRunnable(StrikePractice plugin, Party party, BattleKit kit) {
        this.party = party;
        this.plugin = plugin;
        this.kit = kit;
        int elos = 0;
        for (Player mem : party.getPlayers()) {
            elos += DefaultPlayerStats.getStats((UUID)mem.getUniqueId()).getElo(kit);
            mem.setMetadata(RANKED_QUEUE, (MetadataValue)new FixedMetadataValue((Plugin)plugin, (Object)this));
        }
        this.currentElo = elos /= party.getMembersNames().size();
        this.range += plugin.getConfig().getInt("ranked.elo-range-increase");
    }

    @Override
    public void run() {
        ++this.counter;
        if (this.counter >= this.plugin.getConfig().getInt("ranked.anyone-after")) {
            if (!this.anyone) {
                for (Player p2 : this.party.getPlayers()) {
                    this.plugin.sendMessage(p2, "ranked-anyone");
                }
            }
            this.anyone = true;
        } else {
            ++this.counter;
            if (this.counter % this.plugin.getConfig().getInt("ranked.elo-range-time") == 0) {
                this.range += this.plugin.getConfig().getInt("ranked.elo-range-increase");
                for (Player p3 : this.party.getPlayers()) {
                    this.plugin.sendMessage(p3, "ranked-range", MapUtil.mapOf((Object[])new Object[]{"<range1>", this.getFromRange(), "<range2>", this.getToRange()}));
                }
            }
        }
        PartyQueueRunnable opponent = this.getOpponent();
        if (opponent != null) {
            QueueRunner.removeQueue((QueueRunnable)opponent);
            QueueRunner.removeQueue((QueueRunnable)this);
        }
    }

    private PartyQueueRunnable getOpponent() {
        for (PartyQueueRunnable qr : (Collection)PartyQueueManager.ranked.get(this.kit)) {
            Party party2;
            if (qr.equals(this) || (party2 = qr.getParty()) == null || !qr.getKit().equals(this.kit) || (Math.abs(qr.getCurrentElo() - this.getCurrentElo()) >= this.range || Math.abs(qr.getCurrentElo() - this.getCurrentElo()) >= qr.getRange()) && (!qr.isAnyone() || !this.anyone) || !this.isValidQueue() || !qr.isValidQueue()) continue;
            for (Player p2 : this.party.getPlayers()) {
                p2.removeMetadata("StrikePracticeWaiting2v2Queue", (Plugin)this.plugin);
                PlayerInventory.closeInventorySafe((Player)p2);
            }
            for (Player p2 : party2.getPlayers()) {
                p2.removeMetadata("StrikePracticeWaiting2v2Queue", (Plugin)this.plugin);
                PlayerInventory.closeInventorySafe((Player)p2);
            }
            new /* Unavailable Anonymous Inner Class!! */.runTask((Plugin)this.plugin);
            return qr;
        }
        return null;
    }

    public static PartyQueueRunnable getRanked(Player p2) {
        MetadataValue mv = StrikePractice.getInstance().getMetadata((Metadatable)p2, RANKED_QUEUE);
        if (mv != null && mv.value() instanceof PartyQueueRunnable) {
            return (PartyQueueRunnable)mv.value();
        }
        return null;
    }

    @Override
    public boolean isValidQueue() {
        if (this.party == null || this.party.getMembersNames().size() != 2 || this.party.isInFight() || this.party.getPlayers().stream().anyMatch(p2 -> AbstractFight.isInFight(p2) || PvPEvent.isInEvent(p2))) {
            return false;
        }
        Player p3 = this.party.getOwnerPlayer();
        return p3 != null && PartyQueueRunnable.getRanked(p3) == this;
    }

    @Override
    public int getFromRange() {
        return Math.max(0, this.currentElo - this.range);
    }

    @Override
    public int getToRange() {
        return this.currentElo + this.range;
    }

    @Override
    public int getCurrentElo() {
        return this.currentElo;
    }

    @Override
    public int getRange() {
        return this.range;
    }

    @Override
    public BattleKit getKit() {
        return this.kit;
    }

    @Override
    public void setRange(int range) {
        this.range = range;
    }

    @Override
    public boolean isAnyone() {
        return this.anyone;
    }

    @Override
    public void setAnyone(boolean anyone) {
        this.anyone = anyone;
    }

    @Override
    public int getCounter() {
        return this.counter;
    }

    @Override
    public void setCounter(int counter) {
        this.counter = counter;
    }

    public Party getParty() {
        return this.party;
    }

    static /* synthetic */ BattleKit access$000(PartyQueueRunnable x0) {
        return x0.kit;
    }

    static /* synthetic */ StrikePractice access$100(PartyQueueRunnable x0) {
        return x0.plugin;
    }

    static /* synthetic */ Party access$200(PartyQueueRunnable x0) {
        return x0.party;
    }
}

