/*
 * Decompiled with CFR 0.152.
 */
package ga.strikepractice.fights.party.partyfights;

import ga.strikepractice.StrikePractice;
import ga.strikepractice.api.APIClass;
import ga.strikepractice.arena.DefaultArena;
import ga.strikepractice.battlekit.BattleKit;
import ga.strikepractice.events.PartyVsPartyEndEvent;
import ga.strikepractice.events.PartyVsPartyStartEvent;
import ga.strikepractice.fightinventory.FightInventory;
import ga.strikepractice.fights.AbstractFight;
import ga.strikepractice.fights.party.partyfights.PartyFight;
import ga.strikepractice.fights.requests.PartyVsPartyRequest;
import ga.strikepractice.party.Party;
import ga.strikepractice.stats.DefaultPlayerStats;
import ga.strikepractice.stats.Stats;
import ga.strikepractice.utils.Countdown;
import ga.strikepractice.utils.MapUtil;
import ga.strikepractice.utils.PlayerUtil;
import ga.strikepractice.utils.Scheduler;
import ga.strikepractice.utils.Teleporter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

@APIClass
public class PartyVsParty
extends AbstractFight
implements PartyFight {
    private final StrikePractice plugin;
    public Party p1;
    public Party p2;
    private final HashSet<String> partyAlive1;
    private final HashSet<String> partyAlive2;
    private boolean cancelled;
    private boolean ended;
    private boolean queue;
    public PartyVsPartyRequest request;

    public PartyVsParty(StrikePractice plugin, Party p1, Party p2, BattleKit kit) {
        this.plugin = plugin;
        this.p1 = p1;
        this.p2 = p2;
        this.kit = kit;
        this.partyAlive1 = new HashSet(p1.getMembersNames().size());
        this.partyAlive2 = new HashSet(p2.getMembersNames().size());
    }

    @Override
    public boolean canStart() {
        if (this.arena == null) {
            this.arena = this.kit.isBuild() ? DefaultArena.findEmptyBuildArena((Player)this.p1.getOwnerPlayer(), (BattleKit)this.kit) : DefaultArena.findEmptyArena((Player)this.p1.getOwnerPlayer(), (BattleKit)this.kit);
        }
        return this.arena != null && !this.arena.needsRollback() && !this.arena.isUsing() && this.arena.getLoc1() != null && this.arena.getLoc2() != null && this.arena.getLoc1().getWorld() != null && this.arena.getLoc1().getWorld().getName().equals(this.arena.getLoc2().getWorld().getName());
    }

    @Override
    public Party[] getParties() {
        return new Party[]{this.p1, this.p2};
    }

    @Override
    public void start() {
        super.start();
        PartyVsPartyStartEvent event = new PartyVsPartyStartEvent(this, this.p1, this.p2);
        Bukkit.getPluginManager().callEvent((Event)event);
        this.cancelled = event.isCancelled();
        if (!this.cancelled) {
            Player member;
            this.setStartedAfterCountdown();
            this.arena.setUsing(true, this);
            this.p1.setFight(this);
            this.p2.setFight(this);
            this.p2.setOpponent(this.p1);
            this.p1.setOpponent(this.p2);
            String prefix = this.plugin.getPrefix();
            for (String name : this.p1.getMembersNames()) {
                member = PlayerUtil.getPlayer((String)name);
                if (member == null) continue;
                this.initPlayer(member, true);
            }
            for (String name : this.p2.getMembersNames()) {
                member = PlayerUtil.getPlayer((String)name);
                if (member == null) continue;
                this.initPlayer(member, false);
            }
            this.startCountdown();
            this.plugin.getFileManager().addFight(this.kit);
        }
    }

    private void startCountdown() {
        ArrayList<String> players = new ArrayList<String>();
        players.addAll(this.p1.getMembersNames());
        players.addAll(this.p2.getMembersNames());
        Countdown.startCountdown(players, (this.kit == null || this.kit.isStickSpawn() ? 1 : 0) != 0);
    }

    private void initPlayer(Player member, boolean team1) {
        this.plugin.clear(member, false, false);
        if (!Teleporter.teleport((Player)member, (Location)(team1 ? this.arena.getLoc1() : this.arena.getLoc2()))) {
            this.forceEndDelayed(ChatColor.RED + "An error occurred in your fight and the fight was forced to end!");
            return;
        }
        AbstractFight.setCurrentFight(member, this);
        this.kit.giveKit(member);
        if (team1) {
            this.partyAlive1.add(member.getName());
        } else {
            this.partyAlive2.add(member.getName());
        }
        if (this.plugin.getTagManager().coloredTagsEnabled) {
            if (team1) {
                this.plugin.getTagManager().setTagToNames(member, "team1", this.p1.getMembersNames());
                this.plugin.getTagManager().setTagToNames(member, "team2", this.p2.getMembersNames());
            } else {
                this.plugin.getTagManager().setTagToNames(member, "team2", this.p1.getMembersNames());
                this.plugin.getTagManager().setTagToNames(member, "team1", this.p2.getMembersNames());
            }
        }
        this.plugin.sendMessage(member, "fight-start-message.party-vs-party");
        this.kit.sendFightInfo(member);
    }

    @Override
    public void handleDeath(Player p2) {
        Player mem;
        HashSet<String> oAlive;
        HashSet<String> alive;
        Party party = Party.getParty(p2);
        if (this.partyAlive1.contains(p2.getName())) {
            alive = this.partyAlive1;
            oAlive = this.partyAlive2;
        } else if (this.partyAlive2.contains(p2.getName())) {
            alive = this.partyAlive2;
            oAlive = this.partyAlive1;
        } else {
            return;
        }
        new FightInventory(p2, this.plugin);
        this.plugin.clear(p2, false, true);
        AbstractFight.setCurrentFight(p2, null);
        alive.remove(p2.getName());
        int counter = alive.size();
        for (String s2 : party.getMembersNames()) {
            Player mem2 = PlayerUtil.getPlayer((String)s2);
            this.plugin.sendMessage(mem2, "your-member-died", MapUtil.mapOf((Object[])new Object[]{"<player>", p2.getName(), "<alive>", counter}));
        }
        Party oParty = party.getOpponent();
        for (String s3 : oParty.getMembersNames()) {
            mem = PlayerUtil.getPlayer((String)s3);
            this.plugin.sendMessage(mem, "opponent-member-died", MapUtil.mapOf((Object[])new Object[]{"<player>", p2.getName(), "<alive>", counter}));
        }
        if (this.plugin.getTagManager().coloredTagsEnabled) {
            this.plugin.getTagManager().removeFromTeams(p2);
        }
        if (counter == 0) {
            Player member;
            this.ended = true;
            ((AbstractFight)this).ended = System.currentTimeMillis();
            Bukkit.getPluginManager().callEvent((Event)new PartyVsPartyEndEvent(this, oParty, party));
            for (String d2 : oAlive) {
                member = PlayerUtil.getPlayer((String)d2);
                if (member == null) continue;
                new FightInventory(member, this.plugin);
                if (!this.plugin.getTagManager().coloredTagsEnabled) continue;
                this.plugin.getTagManager().removeFromTeams(member);
            }
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                boolean spec = this.allowSpectating();
                for (String s1 : party.getMembersNames()) {
                    Player member1 = PlayerUtil.getPlayer((String)s1);
                    if (member1 == null) continue;
                    if (spec && this.plugin.getSpectatorHandler().isSpectator(member1)) {
                        this.plugin.getSpectatorHandler().removeSpectator(member1, true);
                    }
                    AbstractFight.setCurrentFight(member1, null);
                }
                for (String s2 : oParty.getMembersNames()) {
                    Player member2 = PlayerUtil.getPlayer((String)s2);
                    if (member2 == null) continue;
                    if (spec && this.plugin.getSpectatorHandler().isSpectator(member2)) {
                        this.plugin.getSpectatorHandler().removeSpectator(member2, true);
                    }
                    AbstractFight.setCurrentFight(member2, null);
                }
                for (String s3 : oAlive) {
                    Player member3 = PlayerUtil.getPlayer((String)s3);
                    if (member3 == null) continue;
                    this.plugin.clear(member3, true, true);
                }
                if (party != null) {
                    party.setFight(null);
                    party.setOpponent(null);
                }
                if (oParty != null) {
                    oParty.setFight(null);
                    oParty.setOpponent(null);
                }
                if (this.arena != null) {
                    this.arena.setUsing(false, null);
                }
            }, (long)(20 * this.plugin.getConfig().getInt("wait-before-teleport")));
            for (String d2 : oParty.getMembersNames()) {
                member = PlayerUtil.getPlayer((String)d2);
                if (member == null) continue;
                UUID uuid = member.getUniqueId();
                DefaultPlayerStats.getStats((UUID)uuid).setPartyVsPartyWins(DefaultPlayerStats.getStats((UUID)uuid).getPartyVsPartyWins() + 1);
            }
            for (String s3 : party.getMembersNames()) {
                mem = PlayerUtil.getPlayer((String)s3);
                if (mem == null) continue;
                this.plugin.sendMessage(mem, "your-team-did-not-win");
            }
            for (String s3 : oParty.getMembersNames()) {
                mem = PlayerUtil.getPlayer((String)s3);
                if (mem == null) continue;
                this.plugin.sendMessage(mem, "your-team-won");
            }
            Scheduler.async(() -> {
                FightInventory.message(this.p1.getMembersNames(), this.p2.getMembersNames());
                FightInventory.message(this.p2.getMembersNames(), this.p1.getMembersNames());
                this.sendSpectatorMessages(oParty.getMembersNames(), party.getMembersNames());
                if (this.kit.isElo()) {
                    int oElo = 0;
                    for (Player player : oParty.getPlayers()) {
                        oElo += DefaultPlayerStats.getStats((UUID)player.getUniqueId()).getElo(this.kit);
                    }
                    oElo /= oParty.getPlayers().size();
                    int pElo = 0;
                    for (Player player : party.getPlayers()) {
                        pElo += DefaultPlayerStats.getStats((UUID)player.getUniqueId()).getElo(this.kit);
                    }
                    this.doElo(oParty, oElo, party, pElo /= party.getPlayers().size());
                }
            });
        }
    }

    @Override
    public boolean allowSpectating() {
        return this.plugin.getConfig().getBoolean("allow-spectating");
    }

    @Override
    public boolean hasEnded() {
        return this.ended;
    }

    public Party getParty1() {
        return this.p1;
    }

    public Party getParty2() {
        return this.p2;
    }

    public HashSet<String> getPartyAlive1() {
        return this.partyAlive1;
    }

    public boolean isQueue() {
        return this.queue;
    }

    public void setQueue(boolean queue) {
        this.queue = queue;
    }

    public HashSet<String> getPartyAlive2() {
        return this.partyAlive2;
    }

    public void forceEnd(Party loser) {
        Player mem;
        Bukkit.getPluginManager().callEvent((Event)new PartyVsPartyEndEvent(this, this.p2 == loser ? this.p1 : this.p2, loser));
        for (String s2 : this.p2.getMembersNames()) {
            mem = PlayerUtil.getPlayer((String)s2);
            if (mem == null) continue;
            if (!loser.getOwner().equals(this.p2.getOwner())) {
                this.plugin.sendMessage(mem, "your-team-won-disband");
            }
            AbstractFight.setCurrentFight(mem, null);
            if (this.plugin.getSpectatorHandler().isSpectator(mem)) {
                this.plugin.getSpectatorHandler().removeSpectator(mem, true);
            }
            this.plugin.clear(mem, true, true);
            if (!this.plugin.getTagManager().coloredTagsEnabled) continue;
            this.plugin.getTagManager().removeFromTeams(mem);
        }
        this.p2.setFight(null);
        this.p2.setOpponent(null);
        for (String s2 : this.p1.getMembersNames()) {
            mem = PlayerUtil.getPlayer((String)s2);
            if (mem == null) continue;
            if (!loser.getOwner().equals(this.p1.getOwner())) {
                this.plugin.sendMessage(mem, "your-team-won-disband");
            }
            AbstractFight.setCurrentFight(mem, null);
            if (this.plugin.getSpectatorHandler().isSpectator(mem)) {
                this.plugin.getSpectatorHandler().removeSpectator(mem, true);
            }
            this.plugin.clear(mem, true, true);
            if (!this.plugin.getTagManager().coloredTagsEnabled) continue;
            this.plugin.getTagManager().removeFromTeams(mem);
        }
        this.p1.setFight(null);
        this.p1.setOpponent(null);
        if (this.arena != null) {
            this.arena.setUsing(false, null);
        }
    }

    @Override
    public List<String> getTeammates(Player p2) {
        Party party = Party.getParty(p2);
        if (party == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(party.getMembersNames());
    }

    @Override
    public List<String> getOpponents(Player p2) {
        Party party = Party.getParty(p2);
        return new ArrayList<String>(party == this.getParty1() ? this.getParty2().getMembersNames() : this.getParty1().getMembersNames());
    }

    @Override
    public void forceEnd(String reason) {
        Player mem;
        Bukkit.getPluginManager().callEvent((Event)new PartyVsPartyEndEvent(this, null, null));
        for (String s2 : this.p1.getMembersNames()) {
            mem = PlayerUtil.getPlayer((String)s2);
            if (mem == null) continue;
            if (reason != null) {
                mem.sendMessage(reason);
            }
            AbstractFight.setCurrentFight(mem, null);
            if (this.plugin.getSpectatorHandler().isSpectator(mem)) {
                this.plugin.getSpectatorHandler().removeSpectator(mem, true);
            }
            this.plugin.clear(mem, true, true, true);
            this.p1.setFight(null);
            this.p1.setOpponent(null);
        }
        for (String s2 : this.p2.getMembersNames()) {
            mem = PlayerUtil.getPlayer((String)s2);
            if (mem == null) continue;
            if (reason != null) {
                mem.sendMessage(reason);
            }
            AbstractFight.setCurrentFight(mem, null);
            if (this.plugin.getSpectatorHandler().isSpectator(mem)) {
                this.plugin.getSpectatorHandler().removeSpectator(mem, true);
            }
            this.plugin.clear(mem, true, true, true);
            this.p1.setFight(null);
            this.p1.setOpponent(null);
        }
        if (this.arena != null) {
            this.arena.setUsing(false, null);
        }
        this.ended = true;
        ((AbstractFight)this).ended = System.currentTimeMillis();
    }

    private void doElo(Party opponent, int i2, Party p2, int j2) {
        int n2;
        int old1 = i2;
        int old2 = j2;
        int k2 = i2;
        int m2 = j2;
        if (i2 > j2) {
            n2 = i2 - j2;
            if (n2 > 100 && n2 <= 200) {
                k2 = i2 + 4;
                m2 = j2 - 4;
            }
            if (n2 > 200) {
                k2 = i2 + 3;
                m2 = j2 - 3;
            }
            if (n2 > 50 && n2 <= 100) {
                k2 = i2 + 6;
                m2 = j2 - 6;
            }
            if (n2 <= 50) {
                k2 = i2 + 7;
                m2 = j2 - 7;
            }
        }
        if (i2 == j2) {
            k2 = i2 + 8;
            m2 = j2 - 8;
        }
        if (j2 > i2) {
            n2 = j2 - i2;
            if (n2 > 100 && n2 <= 150) {
                m2 = j2 - 15;
                k2 = i2 + 15;
            }
            if (n2 > 150 && n2 <= 200) {
                m2 = j2 - 17;
                k2 = i2 + 17;
            }
            if (n2 > 200) {
                m2 = j2 - 21;
                k2 = i2 + 21;
            }
            if (n2 > 50 && n2 <= 100) {
                m2 = j2 - 13;
                k2 = i2 + 13;
            }
            if (n2 <= 50) {
                m2 = j2 - 10;
                k2 = i2 + 10;
            }
        }
        int diff1 = k2 - old1;
        int diff2 = m2 - old2;
        String p1Name = opponent.getOwner() + "'s party";
        String p2Name = p2.getOwner() + "'s party";
        this.sendEloChangeMsg(p2, old1, old2, k2, m2, diff1, diff2, p1Name, p2Name, m2 + "");
        this.sendEloChangeMsg(opponent, old1, old2, k2, k2, diff1, diff2, p1Name, p2Name, m2 + "");
    }

    private void sendEloChangeMsg(Party p2, int old1, int old2, int k2, int m2, int diff1, int diff2, String p1Name, String p2Name, String s2) {
        boolean eloIsGlobal = this.plugin.getConfig().getBoolean("elo-is-global-elo");
        for (Player pl : p2.getPlayers()) {
            if (eloIsGlobal) {
                this.plugin.kits.forEach(kit -> {
                    if (kit.isElo()) {
                        DefaultPlayerStats.getStats((UUID)pl.getUniqueId()).getElos().put(Stats.eloColumn((BattleKit)kit), m2);
                    }
                });
            } else {
                DefaultPlayerStats.getStats((UUID)pl.getUniqueId()).getElos().put(Stats.eloColumn((BattleKit)this.kit), m2);
            }
            this.plugin.sendMessage(pl, "elo-fight", MapUtil.mapOf((Object[])new Object[]{"<player1>", p1Name, "<player2>", p2Name, "<elo1>", k2, "<elo2>", s2, "<old1>", old1, "<old2>", old2, "<diff1>", diff1, "<diff2>", diff2}));
        }
    }
}

