/*
 * Decompiled with CFR 0.152.
 */
package ga.strikepractice.fights.party.partyfights;

import ga.strikepractice.StrikePractice;
import ga.strikepractice.api.APIClass;
import ga.strikepractice.arena.DefaultArena;
import ga.strikepractice.battlekit.BattleKit;
import ga.strikepractice.bot.PracticeBot;
import ga.strikepractice.events.PartyVsBotsEndEvent;
import ga.strikepractice.events.PartyVsBotsStartEvent;
import ga.strikepractice.fightinventory.FightInventory;
import ga.strikepractice.fights.AbstractFight;
import ga.strikepractice.fights.BotFight;
import ga.strikepractice.fights.Fight;
import ga.strikepractice.fights.party.partyfights.PartyFight;
import ga.strikepractice.npc.CitizensNPC;
import ga.strikepractice.party.Party;
import ga.strikepractice.utils.CommonUtil;
import ga.strikepractice.utils.Countdown;
import ga.strikepractice.utils.MapUtil;
import ga.strikepractice.utils.PlayerUtil;
import ga.strikepractice.utils.Scheduler;
import ga.strikepractice.utils.Teleporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.metadata.Metadatable;
import org.bukkit.plugin.Plugin;

@APIClass
public class PartyVsBots
extends AbstractFight
implements BotFight,
PartyFight {
    private final StrikePractice plugin;
    private final Party party;
    private final Map<PracticeBot, Boolean> botsAlive = new HashMap<PracticeBot, Boolean>();
    private final Set<String> playersAlive = new HashSet<String>();
    private boolean cancelled;
    private boolean ended;
    private String difficulty;

    public PartyVsBots(StrikePractice plugin, Party party, BattleKit kit) {
        this.plugin = plugin;
        this.party = party;
        this.kit = kit;
    }

    @Override
    public void start() {
        super.start();
        PartyVsBotsStartEvent event = new PartyVsBotsStartEvent(this, this.party);
        Bukkit.getPluginManager().callEvent((Event)event);
        this.cancelled = event.isCancelled();
        if (!this.cancelled) {
            this.setStartedAfterCountdown();
            this.arena.setUsing(true, this);
            this.party.setFight(this);
            boolean tags = this.plugin.getConfig().getBoolean("enable-colored-names");
            ArrayList<UUID> players = new ArrayList<UUID>();
            for (String name : this.party.getMembersNames()) {
                Player member = PlayerUtil.getPlayer((String)name);
                if (member == null) continue;
                players.add(member.getUniqueId());
            }
            String botNameTemplate = CommonUtil.translateColors((String)this.plugin.getConfig().getString("bot-name"));
            for (UUID uuid : players) {
                Player member = Bukkit.getPlayer((UUID)uuid);
                if (member == null) continue;
                if (this.plugin.getSpectatorHandler().isSpectator(member)) {
                    this.plugin.getSpectatorHandler().removeSpectator(member, false);
                }
                if (member.isDead()) {
                    member.spigot().respawn();
                }
                this.plugin.clear(member, false, false);
                if (!Teleporter.teleport((Player)member, (Location)this.arena.getLoc1())) {
                    this.forceEndDelayed(ChatColor.RED + "An error occurred in your fight and the fight was forced to end!");
                    return;
                }
                member.setHealth(member.getMaxHealth());
                member.setFoodLevel(20);
                AbstractFight.setCurrentFight(member, this);
                this.kit.giveKit(member);
                if (tags) {
                    this.plugin.getTagManager().setTagToUUIDS(member, "team1", players);
                }
                this.plugin.sendMessage(member, "fight-start-message.party-bots");
                this.kit.sendFightInfo(member);
                this.playersAlive.add(member.getName());
                PracticeBot bot = this.plugin.getBotManager().shouldUseModern() ? this.plugin.getBotManager().createModernBot(this.difficulty, this.arena.getLoc2(), players, (Fight)this) : this.plugin.getBotManager().createLegacyBot(botNameTemplate.replace("<player>", member.getName()), member.getName(), this.arena.getLoc2(), (Fight)this, players, CitizensNPC.Difficulty.of(this.difficulty));
                this.botsAlive.put(bot, true);
            }
            this.startCountdown();
            this.plugin.getFileManager().addFight(this.kit);
            new /* Unavailable Anonymous Inner Class!! */.runTaskTimer((Plugin)this.plugin, 400L, 100L);
        }
    }

    @Override
    public Party[] getParties() {
        return new Party[]{this.party};
    }

    @Override
    public boolean allowSpectating() {
        return this.plugin.getConfig().getBoolean("allow-spectating");
    }

    @Override
    public boolean hasEnded() {
        return this.ended;
    }

    @Override
    public boolean canStart() {
        if (this.arena == null) {
            this.arena = this.kit.isBuild() ? DefaultArena.findEmptyBuildArena((Player)PlayerUtil.getPlayer((String)this.party.getOwner()), (BattleKit)this.kit) : DefaultArena.findEmptyArena((Player)PlayerUtil.getPlayer((String)this.party.getOwner()), (BattleKit)this.kit);
        }
        return this.arena != null && !this.arena.needsRollback() && !this.arena.isUsing() && this.arena.getLoc1() != null && this.arena.getLoc2() != null && this.arena.getLoc1().getWorld() != null && this.arena.getLoc1().getWorld().getName().equals(this.arena.getLoc2().getWorld().getName());
    }

    @Override
    public void handleDeath(Player p2) {
        Party party = Party.getParty(p2);
        if (this.playersAlive.contains(p2.getName())) {
            new FightInventory(p2, this.plugin);
            this.plugin.clear(p2, false, true);
            AbstractFight.setCurrentFight(p2, null);
            this.playersAlive.remove(p2.getName());
            int counter = this.playersAlive.size();
            for (String string : party.getMembersNames()) {
                Player mem2 = PlayerUtil.getPlayer((String)string);
                if (mem2 == null) continue;
                this.plugin.sendMessage(mem2, "your-member-died", MapUtil.mapOf((Object[])new Object[]{"<player>", p2.getName(), "<alive>", counter}));
            }
            if (this.plugin.getTagManager().coloredTagsEnabled) {
                this.plugin.getTagManager().removeFromTeams(p2);
            }
            if (counter == 0) {
                Bukkit.getPluginManager().callEvent((Event)new PartyVsBotsEndEvent(this, party, PartyVsBotsEndEvent.Winners.BOTS));
                this.ended = true;
                ((AbstractFight)this).ended = System.currentTimeMillis();
                for (Map.Entry entry : this.botsAlive.entrySet()) {
                    if (!((Boolean)entry.getValue()).booleanValue()) continue;
                    try {
                        new FightInventory((Entity)((PracticeBot)entry.getKey()).getBukkitEntity(), ((PracticeBot)entry.getKey()).getNPC().getName(), ((PracticeBot)entry.getKey()).getBukkitEntity().getInventory(), this.plugin);
                        AbstractFight.setCurrentFight(((PracticeBot)entry.getKey()).getBukkitEntity(), this);
                    }
                    catch (Exception mem2) {}
                }
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                    boolean spec = this.allowSpectating();
                    for (Map.Entry<PracticeBot, Boolean> d2 : this.botsAlive.entrySet()) {
                        if (!d2.getValue().booleanValue()) continue;
                        d2.getKey().destroy();
                    }
                    for (String s2 : party.getMembersNames()) {
                        Player member = PlayerUtil.getPlayer((String)s2);
                        if (member == null) continue;
                        if (spec && this.plugin.getSpectatorHandler().isSpectator(member)) {
                            this.plugin.getSpectatorHandler().removeSpectator(member, true);
                        }
                        AbstractFight.setCurrentFight(member, null);
                    }
                    party.setFight(null);
                    party.setOpponent(null);
                    if (this.arena != null) {
                        this.arena.setUsing(false, null);
                    }
                }, 20L * (long)this.plugin.getConfig().getInt("wait-before-teleport"));
                for (String string : party.getMembersNames()) {
                    Player mem = PlayerUtil.getPlayer((String)string);
                    if (mem == null) continue;
                    this.plugin.sendMessage(mem, "your-team-did-not-win");
                }
                HashSet<String> botNames = new HashSet<String>();
                for (PracticeBot d3 : this.botsAlive.keySet()) {
                    if (d3 == null || d3.getNPC() == null) continue;
                    botNames.add(d3.getNPC().getName());
                }
                Scheduler.async(() -> {
                    FightInventory.message(party.getMembersNames(), botNames);
                    this.sendSpectatorMessages(botNames, party.getMembersNames());
                });
            }
        }
    }

    @Override
    public void forceEnd(String reason) {
        Bukkit.getPluginManager().callEvent((Event)new PartyVsBotsEndEvent(this, this.party, PartyVsBotsEndEvent.Winners.FORCE_END));
        for (String s2 : this.party.getMembersNames()) {
            Player mem = PlayerUtil.getPlayer((String)s2);
            if (mem == null) continue;
            if (reason != null) {
                mem.sendMessage(reason);
            }
            AbstractFight.setCurrentFight(mem, null);
            if (this.plugin.getSpectatorHandler().isSpectator(mem)) {
                this.plugin.getSpectatorHandler().removeSpectator(mem, true);
            }
            this.plugin.clear(mem, true, true, true);
            this.party.setFight(null);
            if (!this.plugin.getTagManager().coloredTagsEnabled) continue;
            this.plugin.getTagManager().removeFromTeams(mem);
        }
        for (PracticeBot npc : this.botsAlive.keySet()) {
            if (npc instanceof CitizensNPC) {
                ((CitizensNPC)npc).destroy(true);
                continue;
            }
            npc.destroy();
        }
        if (this.arena != null) {
            this.arena.setUsing(false, null);
        }
        this.ended = true;
        ((AbstractFight)this).ended = System.currentTimeMillis();
    }

    private void startCountdown() {
        Countdown.startCountdown(this.party.getMembersNames(), (this.kit == null || this.kit.isStickSpawn() ? 1 : 0) != 0);
    }

    private void botDeathEndsFight(String botName) {
        Player mem;
        int counter = 0;
        try {
            for (Map.Entry<PracticeBot, Boolean> c2 : this.botsAlive.entrySet()) {
                if (!c2.getValue().booleanValue()) continue;
                ++counter;
            }
            for (String s2 : this.party.getMembersNames()) {
                mem = PlayerUtil.getPlayer((String)s2);
                if (mem == null) continue;
                this.plugin.sendMessage(mem, "opponent-member-died", MapUtil.mapOf((Object[])new Object[]{"<player>", botName, "<alive>", counter}));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (counter == 0) {
            Bukkit.getPluginManager().callEvent((Event)new PartyVsBotsEndEvent(this, this.party, PartyVsBotsEndEvent.Winners.PLAYERS));
            this.ended = true;
            ((AbstractFight)this).ended = System.currentTimeMillis();
            for (String d2 : this.playersAlive) {
                Player member = PlayerUtil.getPlayer((String)d2);
                if (member == null) continue;
                new FightInventory(member, this.plugin);
                if (!this.plugin.getTagManager().coloredTagsEnabled) continue;
                this.plugin.getTagManager().removeFromTeams(member);
            }
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                boolean spec = this.allowSpectating();
                for (String s1 : this.party.getMembersNames()) {
                    Player member1 = PlayerUtil.getPlayer((String)s1);
                    if (member1 == null) continue;
                    if (spec && this.plugin.getSpectatorHandler().isSpectator(member1)) {
                        this.plugin.getSpectatorHandler().removeSpectator(member1, true);
                    }
                    AbstractFight.setCurrentFight(member1, null);
                }
                for (String s2 : this.playersAlive) {
                    Player member2 = PlayerUtil.getPlayer((String)s2);
                    if (member2 == null) continue;
                    this.plugin.clear(member2, true, true);
                }
                this.party.setFight(null);
                this.party.setOpponent(null);
                if (this.arena != null) {
                    this.arena.setUsing(false, null);
                }
            }, 20L * (long)this.plugin.getConfig().getInt("wait-before-teleport"));
            for (String s2 : this.party.getMembersNames()) {
                mem = PlayerUtil.getPlayer((String)s2);
                if (mem == null) continue;
                this.plugin.sendMessage(mem, "your-team-won");
            }
            HashSet<String> botNames = new HashSet<String>(this.botsAlive.size());
            for (PracticeBot d3 : this.botsAlive.keySet()) {
                if (d3.getNPC() == null) continue;
                botNames.add(d3.getNPC().getName());
            }
            Scheduler.async(() -> {
                FightInventory.message(this.party.getMembersNames(), botNames);
                this.sendSpectatorMessages(this.party.getMembersNames(), botNames);
            });
        }
    }

    @Deprecated
    public HashMap<PracticeBot, Boolean> getBotsTeam() {
        return (HashMap)this.botsAlive;
    }

    @Deprecated
    public HashSet<String> getPlayersTeam() {
        return this.party.getMembers();
    }

    public Set<String> getPlayers() {
        return this.party.getMembersNames();
    }

    @Deprecated
    public HashSet<String> getPlayersAlive() {
        return (HashSet)this.playersAlive;
    }

    public Set<String> getAlivePlayers() {
        return this.playersAlive;
    }

    public HashSet<PracticeBot> getBotsAlive() {
        HashSet<PracticeBot> alive = new HashSet<PracticeBot>();
        for (Map.Entry<PracticeBot, Boolean> e2 : this.botsAlive.entrySet()) {
            if (!e2.getValue().booleanValue()) continue;
            alive.add(e2.getKey());
        }
        return alive;
    }

    @Override
    public List<String> getTeammates(Player p2) {
        return new ArrayList<String>(this.party.getMembersNames());
    }

    @Override
    public List<String> getOpponents(Player p2) {
        return this.botsAlive.keySet().stream().filter(it -> it.getNPC() != null).map(it -> it.getNPC().getName()).collect(Collectors.toList());
    }

    public Set<PracticeBot> getAliveBots() {
        return this.getBotsAlive();
    }

    @Override
    public CitizensNPC.Difficulty getDifficulty() {
        return CitizensNPC.Difficulty.of(this.difficulty);
    }

    @Override
    public String difficulty() {
        return this.difficulty;
    }

    @Override
    public void setDifficulty(String difficulty) {
        this.difficulty = difficulty;
    }

    @Override
    public void handleBotDeath(Metadatable ent) {
        for (Map.Entry<PracticeBot, Boolean> e2 : this.botsAlive.entrySet()) {
            if (e2.getKey().getBukkitEntity() == null || !e2.getKey().getBukkitEntity().getUniqueId().equals(((Entity)ent).getUniqueId()) || !e2.getValue().booleanValue()) continue;
            this.botsAlive.put(e2.getKey(), false);
            String name = e2.getKey().getNPC().getFullName();
            try {
                new FightInventory((Entity)e2.getKey().getBukkitEntity(), e2.getKey().getNPC().getName(), e2.getKey().getBukkitEntity().getInventory(), this.plugin);
                e2.getKey().destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.botDeathEndsFight(name);
        }
    }

    @Override
    public Collection<PracticeBot> getBots() {
        return this.botsAlive.keySet();
    }

    static /* synthetic */ Map access$000(PartyVsBots x0) {
        return x0.botsAlive;
    }

    static /* synthetic */ void access$100(PartyVsBots x0, String x1) {
        x0.botDeathEndsFight(x1);
    }
}

