/*
 * Decompiled with CFR 0.152.
 */
package ga.strikepractice.fights.party.partyfights;

import ga.strikepractice.StrikePractice;
import ga.strikepractice.api.APIClass;
import ga.strikepractice.arena.DefaultArena;
import ga.strikepractice.battlekit.BattleKit;
import ga.strikepractice.events.PartySplitEndEvent;
import ga.strikepractice.events.PartySplitStartEvent;
import ga.strikepractice.fightinventory.FightInventory;
import ga.strikepractice.fights.AbstractFight;
import ga.strikepractice.fights.party.partyfights.PartyFight;
import ga.strikepractice.party.Party;
import ga.strikepractice.utils.Countdown;
import ga.strikepractice.utils.MapUtil;
import ga.strikepractice.utils.PlayerUtil;
import ga.strikepractice.utils.Scheduler;
import ga.strikepractice.utils.Teleporter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

@APIClass
public class PartySplit
extends AbstractFight
implements PartyFight {
    private final StrikePractice plugin;
    private final Party party;
    private boolean cancelled;
    public final HashSet<String> alive;
    public final HashSet<String> alive2;
    private HashSet<String> team;
    private HashSet<String> team2;
    private boolean ended;

    public PartySplit(StrikePractice plugin, Party party, BattleKit finalKit) {
        this.plugin = plugin;
        this.party = party;
        this.kit = finalKit;
        int teamSize = (int)Math.ceil((double)party.getMembersNames().size() / 2.0);
        this.alive = new HashSet(teamSize);
        this.alive2 = new HashSet(teamSize);
    }

    @Override
    public boolean canStart() {
        if (this.arena == null) {
            this.arena = this.kit.isBuild() ? DefaultArena.findEmptyBuildArena((Player)PlayerUtil.getPlayer((String)this.party.getOwner()), (BattleKit)this.kit) : DefaultArena.findEmptyArena((Player)PlayerUtil.getPlayer((String)this.party.getOwner()), (BattleKit)this.kit);
        }
        return this.arena != null && !this.arena.needsRollback() && !this.arena.isUsing() && this.arena.getLoc1() != null && this.arena.getLoc2() != null && this.arena.getLoc1().getWorld() != null && this.arena.getLoc1().getWorld().getName().equals(this.arena.getLoc2().getWorld().getName());
    }

    @Override
    public void start() {
        super.start();
        PartySplitStartEvent event = new PartySplitStartEvent(this, this.party);
        Bukkit.getPluginManager().callEvent((Event)event);
        this.cancelled = event.isCancelled();
        if (!this.cancelled) {
            Player member;
            this.setStartedAfterCountdown();
            this.arena.setUsing(true, this);
            this.party.setFight(this);
            ArrayList<String> playerList = new ArrayList<String>(this.party.getMembersNames());
            Collections.shuffle(playerList);
            for (String pName : playerList) {
                if (this.alive2.size() > this.alive.size()) {
                    this.alive.add(pName);
                    continue;
                }
                this.alive2.add(pName);
            }
            for (String name : this.alive) {
                member = PlayerUtil.getPlayer((String)name);
                if (member == null) continue;
                this.initPlayer(member, this.arena.getLoc1(), true);
            }
            for (String name : this.alive2) {
                member = PlayerUtil.getPlayer((String)name);
                if (member == null) continue;
                this.initPlayer(member, this.arena.getLoc2(), false);
            }
            this.team = new HashSet<String>(this.alive);
            this.team2 = new HashSet<String>(this.alive2);
            this.startCountdown();
            this.plugin.getFileManager().addFight(this.kit);
        }
    }

    private void initPlayer(Player member, Location loc, boolean team1) {
        try {
            if (member.isDead()) {
                member.spigot().respawn();
            }
            this.plugin.clear(member, false, false);
            if (!Teleporter.teleport((Player)member, (Location)loc)) {
                this.forceEndDelayed(ChatColor.RED + "An error occurred in your fight and the fight was forced to end!");
                return;
            }
            AbstractFight.setCurrentFight(member, this);
            this.kit.giveKit(member);
            if (this.plugin.getTagManager().coloredTagsEnabled) {
                if (team1) {
                    this.plugin.getTagManager().setTagToNames(member, "team1", this.alive);
                    this.plugin.getTagManager().setTagToNames(member, "team2", this.alive2);
                } else {
                    this.plugin.getTagManager().setTagToNames(member, "team1", this.alive2);
                    this.plugin.getTagManager().setTagToNames(member, "team2", this.alive);
                }
            }
            this.plugin.sendMessage(member, "fight-start-message.party-split");
            this.kit.sendFightInfo(member);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            this.forceEndDelayed("Something went wrong...");
        }
    }

    private void startCountdown() {
        Countdown.startCountdown(this.party.getMembersNames(), (this.kit == null || this.kit.isStickSpawn() ? 1 : 0) != 0);
    }

    @Override
    public void handleDeath(Player p2) {
        Player mem;
        HashSet<String> wTeam;
        HashSet<String> lTeam;
        HashSet<String> oAlive;
        HashSet<String> alive;
        Party party = Party.getParty(p2);
        if (this.alive.contains(p2.getName())) {
            alive = this.alive;
            oAlive = this.alive2;
            lTeam = this.team;
            wTeam = this.team2;
        } else if (this.alive2.contains(p2.getName())) {
            alive = this.alive2;
            oAlive = this.alive;
            lTeam = this.team2;
            wTeam = this.team;
        } else {
            return;
        }
        new FightInventory(p2, this.plugin);
        this.plugin.clear(p2, false, true);
        AbstractFight.setCurrentFight(p2, null);
        alive.remove(p2.getName());
        int counter = alive.size();
        for (String s2 : lTeam) {
            mem = PlayerUtil.getPlayer((String)s2);
            if (mem == null) continue;
            this.plugin.sendMessage(mem, "your-member-died", MapUtil.mapOf((Object[])new Object[]{"<player>", p2.getName(), "<alive>", counter}));
        }
        for (String s2 : wTeam) {
            mem = PlayerUtil.getPlayer((String)s2);
            if (mem == null) continue;
            this.plugin.sendMessage(mem, "opponent-member-died", MapUtil.mapOf((Object[])new Object[]{"<player>", p2.getName(), "<alive>", counter}));
        }
        if (this.plugin.getTagManager().coloredTagsEnabled) {
            this.plugin.getTagManager().removeFromTeams(p2);
        }
        if (counter == 0) {
            Bukkit.getPluginManager().callEvent((Event)new PartySplitEndEvent(this, party, oAlive, alive));
            this.ended = true;
            ((AbstractFight)this).ended = System.currentTimeMillis();
            for (String d2 : oAlive) {
                Player member = PlayerUtil.getPlayer((String)d2);
                if (member == null) continue;
                new FightInventory(member, this.plugin);
                if (!this.plugin.getTagManager().coloredTagsEnabled) continue;
                this.plugin.getTagManager().removeFromTeams(member);
            }
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                boolean spec = this.allowSpectating();
                for (String s2 : party.getMembersNames()) {
                    Player member = PlayerUtil.getPlayer((String)s2);
                    if (member == null) continue;
                    if (spec && this.plugin.getSpectatorHandler().isSpectator(member)) {
                        this.plugin.getSpectatorHandler().removeSpectator(member, true);
                    }
                    AbstractFight.setCurrentFight(member, null);
                }
                for (String s3 : oAlive) {
                    Player member3 = PlayerUtil.getPlayer((String)s3);
                    if (member3 == null) continue;
                    this.plugin.clear(member3, true, true);
                }
                if (party != null) {
                    party.setFight(null);
                    party.setOpponent(null);
                }
                if (this.arena != null) {
                    this.arena.setUsing(false, null);
                }
            }, (long)(20 * this.plugin.getConfig().getInt("wait-before-teleport")));
            for (String s2 : lTeam) {
                mem = Bukkit.getPlayer((String)s2);
                if (mem == null) continue;
                this.plugin.sendMessage(mem, "your-team-did-not-win");
            }
            for (String s2 : wTeam) {
                mem = Bukkit.getPlayer((String)s2);
                if (mem == null) continue;
                this.plugin.sendMessage(mem, "your-team-won");
            }
            Scheduler.async(() -> {
                FightInventory.message(lTeam, wTeam);
                FightInventory.message(wTeam, lTeam);
                this.sendSpectatorMessages(wTeam, lTeam);
            });
        }
    }

    @Override
    public Party[] getParties() {
        return new Party[]{this.party};
    }

    @Override
    public boolean allowSpectating() {
        return this.plugin.getConfig().getBoolean("allow-spectating");
    }

    @Override
    public List<String> getOpponents(Player p2) {
        String name = p2.getName();
        if (this.getTeam1() == null || this.getTeam2() == null) {
            return new ArrayList<String>(0);
        }
        return new ArrayList<String>(this.getTeam1().contains(name) ? this.getTeam2() : this.getTeam1());
    }

    @Override
    public List<String> getTeammates(Player p2) {
        String name = p2.getName();
        if (this.getTeam1() == null || this.getTeam2() == null) {
            return new ArrayList<String>(0);
        }
        return new ArrayList<String>(this.getTeam1().contains(name) ? this.getTeam1() : this.getTeam2());
    }

    public HashSet<String> getAlive1() {
        return this.alive;
    }

    public HashSet<String> getAlive2() {
        return this.alive2;
    }

    public HashSet<String> getTeam1() {
        return this.team;
    }

    public HashSet<String> getTeam2() {
        return this.team2;
    }

    @Override
    public boolean hasEnded() {
        return this.ended;
    }

    @Override
    public void forceEnd(String reason) {
        Bukkit.getPluginManager().callEvent((Event)new PartySplitEndEvent(this, this.party, new HashSet<String>(), new HashSet<String>()));
        for (String s2 : this.party.getMembersNames()) {
            Player mem = Bukkit.getPlayer((String)s2);
            if (mem == null) continue;
            if (reason != null) {
                mem.sendMessage(reason);
            }
            AbstractFight.setCurrentFight(mem, null);
            if (this.plugin.getSpectatorHandler().isSpectator(mem)) {
                this.plugin.getSpectatorHandler().removeSpectator(mem, true);
            }
            this.plugin.clear(mem, true, true, true);
            this.party.setFight(null);
            if (!this.plugin.getTagManager().coloredTagsEnabled) continue;
            this.plugin.getTagManager().removeFromTeams(mem);
        }
        if (this.arena != null) {
            this.arena.setUsing(false, null);
        }
        this.ended = true;
        ((AbstractFight)this).ended = System.currentTimeMillis();
    }
}

