/*
 * Decompiled with CFR 0.152.
 */
package ga.strikepractice.fights.party.partyfights;

import ga.strikepractice.StrikePractice;
import ga.strikepractice.api.APIClass;
import ga.strikepractice.arena.DefaultArena;
import ga.strikepractice.battlekit.BattleKit;
import ga.strikepractice.events.PartyFFAEndEvent;
import ga.strikepractice.events.PartyFFAStartEvent;
import ga.strikepractice.fightinventory.FightInventory;
import ga.strikepractice.fights.AbstractFight;
import ga.strikepractice.fights.party.partyfights.PartyFight;
import ga.strikepractice.party.Party;
import ga.strikepractice.utils.Countdown;
import ga.strikepractice.utils.LocationUtil;
import ga.strikepractice.utils.MapUtil;
import ga.strikepractice.utils.PlayerUtil;
import ga.strikepractice.utils.Scheduler;
import ga.strikepractice.utils.Teleporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

@APIClass
public class PartyFFA
extends AbstractFight
implements PartyFight {
    private final StrikePractice plugin;
    private final Party party;
    private boolean cancelled;
    private final HashSet<String> alive = new HashSet();
    private final Collection<String> players;
    private boolean ended;

    public PartyFFA(StrikePractice plugin, Party party, BattleKit kit) {
        this.plugin = plugin;
        this.party = party;
        this.kit = kit;
        this.players = new HashSet<String>(party.getMembersNames());
    }

    @Override
    public boolean canStart() {
        if (this.arena == null) {
            this.arena = this.kit.isBuild() ? DefaultArena.findEmptyBuildArena((Player)PlayerUtil.getPlayer((String)this.party.getOwner()), (BattleKit)this.kit) : DefaultArena.findEmptyArena((Player)PlayerUtil.getPlayer((String)this.party.getOwner()), (BattleKit)this.kit);
        }
        return this.arena != null && !this.arena.needsRollback() && !this.arena.isUsing() && this.arena.getLoc1() != null && this.arena.getLoc2() != null && this.arena.getLoc1().getWorld() != null && this.arena.getLoc1().getWorld().getName().equals(this.arena.getLoc2().getWorld().getName());
    }

    @Override
    public void start() {
        super.start();
        PartyFFAStartEvent event = new PartyFFAStartEvent(this, this.party);
        Bukkit.getPluginManager().callEvent((Event)event);
        this.cancelled = event.isCancelled();
        if (!this.cancelled) {
            this.setStartedAfterCountdown();
            int radius = this.plugin.getConfig().getInt("circle-radius");
            List locs = LocationUtil.getCircle((Location)this.arena.getCenter(), (float)radius, (int)this.party.getMembersNames().size());
            this.arena.setUsing(true, this);
            this.party.setFight(this);
            for (String name : this.party.getMembersNames()) {
                if (name == null) continue;
                this.alive.add(name);
                Player member = PlayerUtil.getPlayer((String)name);
                if (member.isDead()) {
                    member.spigot().respawn();
                }
                this.plugin.clear(member, false, false);
                Location center = this.arena.getCenter().clone();
                Location loc = (Location)locs.get(0);
                Location target = loc.setDirection(center.subtract(loc).toVector());
                if (!Teleporter.teleport((Player)member, (Location)target)) {
                    this.forceEndDelayed(ChatColor.RED + "An error occurred in your fight and the fight was forced to end!");
                    return;
                }
                AbstractFight.setCurrentFight(member, this);
                this.kit.giveKit(member);
                locs.remove(0);
                this.plugin.sendMessage(member, "fight-start-message.party-ffa");
                this.kit.sendFightInfo(member);
                if (!this.plugin.getTagManager().coloredTagsEnabled) continue;
                ArrayList<String> others = new ArrayList<String>(this.party.getMembersNames());
                others.remove(member.getName());
                this.plugin.getTagManager().setTagToNames(member, "team2", others);
                this.plugin.getTagManager().setTagToNames(member, "team1", Collections.singletonList(member.getName()));
            }
            this.startCountdown();
            this.plugin.getFileManager().addFight(this.kit);
        }
    }

    private void startCountdown() {
        Countdown.startCountdown(this.party.getMembersNames(), (this.kit == null || this.kit.isStickSpawn() ? 1 : 0) != 0);
    }

    @Override
    public Party[] getParties() {
        return new Party[]{this.party};
    }

    @Override
    public void handleDeath(Player p2) {
        if (!this.alive.contains(p2.getName())) {
            return;
        }
        this.alive.remove(p2.getName());
        int counter = this.alive.size();
        new FightInventory(p2, this.plugin);
        for (String string : this.party.getMembersNames()) {
            Player mem = PlayerUtil.getPlayer((String)string);
            if (mem == null) continue;
            this.plugin.sendMessage(mem, "ffa-died", MapUtil.mapOf((Object[])new Object[]{"<player>", p2.getName(), "<alive>", counter + ""}));
        }
        this.plugin.clear(p2, false, true);
        if (this.plugin.getTagManager().coloredTagsEnabled) {
            this.plugin.getTagManager().removeFromTeams(p2);
        }
        AbstractFight.setCurrentFight(p2, null);
        if (counter == 1) {
            this.ended = true;
            ((AbstractFight)this).ended = System.currentTimeMillis();
            Player winner = null;
            for (String name : this.alive) {
                winner = PlayerUtil.getPlayer((String)name);
            }
            if (winner != null) {
                if (this.plugin.getTagManager().coloredTagsEnabled) {
                    this.plugin.getTagManager().removeFromTeams(winner);
                }
                Player player = winner;
                new FightInventory(winner, this.plugin);
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                    if (this.arena != null) {
                        this.arena.setUsing(false, null);
                    }
                    if (this.party != null) {
                        this.party.setFight(null);
                    }
                    boolean spec = this.allowSpectating();
                    for (String s2 : this.party.getMembersNames()) {
                        Player mem = PlayerUtil.getPlayer((String)s2);
                        if (mem == null) continue;
                        if (spec && this.plugin.getSpectatorHandler().isSpectator(mem)) {
                            this.plugin.getSpectatorHandler().removeSpectator(mem, true);
                        }
                        AbstractFight.setCurrentFight(mem, null);
                    }
                    this.plugin.clear(w2, true, true);
                }, (long)(20 * this.plugin.getConfig().getInt("wait-before-teleport")));
            }
            Bukkit.getPluginManager().callEvent((Event)new PartyFFAEndEvent(this, this.party, winner));
            for (String s3 : this.party.getMembersNames()) {
                Player mem = PlayerUtil.getPlayer((String)s3);
                this.plugin.sendMessage(mem, "ffa-winner", MapUtil.mapOf((Object[])new Object[]{"<player>", winner.getName()}));
            }
            if (this.plugin.getConfig().getBoolean("clickable-messages")) {
                String string = winner.getName();
                Scheduler.async(() -> {
                    ArrayList<FightInventory> invs = new ArrayList<FightInventory>(this.players.size());
                    for (String asd : this.players) {
                        invs.add(this.plugin.getFightInventoryManager().getFightInventory(this.plugin.getFightInventoryManager().getInventoryUUIDByName(asd)));
                    }
                    if (!invs.isEmpty()) {
                        for (int i2 = 0; i2 < invs.size() - 1; ++i2) {
                            FightInventory inv = (FightInventory)invs.get(i2);
                            if (inv == null) continue;
                            inv.setNextInventory((FightInventory)invs.get(i2 + 1));
                        }
                        FightInventory inv = (FightInventory)invs.get(invs.size() - 1);
                        if (inv != null) {
                            inv.setNextInventory((FightInventory)invs.get(0));
                        }
                    }
                    for (String s2 : this.party.getMembersNames()) {
                        Player mem = PlayerUtil.getPlayer((String)s2);
                        if (mem == null) continue;
                        FightInventory.inventoryMessage(mem, invs);
                    }
                    this.sendSpectatorMessages(Collections.singleton(winnerName), this.party.getMembersNames());
                });
            }
        }
    }

    @Override
    public boolean allowSpectating() {
        return this.plugin.getConfig().getBoolean("allow-spectating");
    }

    @Override
    public boolean hasEnded() {
        return this.ended;
    }

    public Party getParty() {
        return this.party;
    }

    public HashSet<String> getAlive() {
        return this.alive;
    }

    @Override
    public List<String> getTeammates(Player p2) {
        return Collections.singletonList(p2.getName());
    }

    @Override
    public List<String> getOpponents(Player p2) {
        String name = p2.getName();
        return this.party.getMembersNames().stream().filter(it -> !name.equals(it)).collect(Collectors.toList());
    }

    @Override
    public void forceEnd(String reason) {
        Bukkit.getPluginManager().callEvent((Event)new PartyFFAEndEvent(this, this.party, null));
        if (this.party == null) {
            return;
        }
        for (String s2 : this.party.getMembersNames()) {
            Player mem = PlayerUtil.getPlayer((String)s2);
            if (mem == null) continue;
            if (reason != null) {
                mem.sendMessage(reason);
            }
            AbstractFight.setCurrentFight(mem, null);
            if (this.plugin.getSpectatorHandler().isSpectator(mem)) {
                this.plugin.getSpectatorHandler().removeSpectator(mem, true);
            }
            this.plugin.clear(mem, true, true, true);
            this.party.setFight(null);
            if (!this.plugin.getTagManager().coloredTagsEnabled) continue;
            this.plugin.getTagManager().removeFromTeams(mem);
        }
        if (this.arena != null) {
            this.arena.setUsing(false, null);
        }
        this.ended = true;
        ((AbstractFight)this).ended = System.currentTimeMillis();
    }

    @Override
    public boolean playersAreOpponents(Player one, Player two) {
        return one != two && this.players.contains(one.getName()) && this.players.contains(two.getName());
    }

    @Override
    public boolean playersAreTeammates(Player one, Player two) {
        return one == two;
    }
}

