/*
 * Decompiled with CFR 0.152.
 */
package ga.strikepractice.fights.elo;

import ga.strikepractice.api.APIClass;
import ga.strikepractice.fights.elo.EloCalculator;
import ga.strikepractice.fights.elo.EloChanges;
import ga.strikepractice.utils.SPDebugger;

@APIClass
public interface EloCalculator {
    public void calculateElo(EloChanges var1);

    public static EloCalculator getEloCalculator() {
        return Companion.eloCalculator;
    }

    public static void setEloCalculator(EloCalculator eloCalculator) {
        Companion.eloCalculator = eloCalculator;
    }

    public static EloCalculator withModifier(EloCalculator eloCalculator, double eloModifier) {
        return eloChanges -> {
            eloCalculator.calculateElo(eloChanges);
            SPDebugger.debug((String)String.format("Calculating elo with modifier %f\nOld elo: %d/%d\nNew elo: %d/%d", eloModifier, eloChanges.getWinnerOldElo(), eloChanges.getLoserOldElo(), eloChanges.getWinnerNewElo(), eloChanges.getLoserNewElo()));
            eloChanges.setWinnerNewElo(eloChanges.getWinnerOldElo() + (int)((double)eloChanges.getWinnerChange() * eloModifier));
            eloChanges.setLoserNewElo(eloChanges.getLoserOldElo() + (int)((double)eloChanges.getLoserChange() * eloModifier));
            SPDebugger.debug((String)String.format("New elo: %d/%d", eloChanges.getWinnerNewElo(), eloChanges.getLoserNewElo()));
        };
    }

    @APIClass
    public static class DefaultEloCalculator
    implements EloCalculator {
        @Override
        public void calculateElo(EloChanges eloChanges) {
            int n2;
            int wOld = eloChanges.getWinnerOldElo();
            int lOld = eloChanges.getLoserOldElo();
            int wNew = wOld;
            int lNew = lOld;
            if (wOld > lOld) {
                n2 = wOld - lOld;
                if (n2 >= 101 && n2 <= 200) {
                    wNew = wOld + 4;
                    lNew = lOld - 4;
                }
                if (n2 > 200) {
                    wNew = wOld + 3;
                    lNew = lOld - 3;
                }
                if (n2 >= 51 && n2 <= 100) {
                    wNew = wOld + 6;
                    lNew = lOld - 6;
                }
                if (n2 <= 50) {
                    wNew = wOld + 7;
                    lNew = lOld - 7;
                }
            }
            if (wOld == lOld) {
                wNew = wOld + 8;
                lNew = lOld - 8;
            }
            if (lOld > wOld) {
                n2 = lOld - wOld;
                if (n2 >= 101 && n2 <= 150) {
                    lNew = lOld - 15;
                    wNew = wOld + 15;
                }
                if (n2 >= 151 && n2 <= 200) {
                    lNew = lOld - 17;
                    wNew = wOld + 17;
                }
                if (n2 > 200) {
                    lNew = lOld - 21;
                    wNew = wOld + 21;
                }
                if (n2 >= 51 && n2 <= 100) {
                    lNew = lOld - 13;
                    wNew = wOld + 13;
                }
                if (n2 <= 50) {
                    lNew = lOld - 10;
                    wNew = wOld + 10;
                }
            }
            lNew = Math.max(lNew, 0);
            wNew = Math.max(wNew, 0);
            eloChanges.setWinnerNewElo(wNew);
            eloChanges.setLoserNewElo(lNew);
        }
    }
}

