/*
 * Decompiled with CFR 0.152.
 */
package ga.strikepractice.fights.duel;

import ga.strikepractice.StrikePractice;
import ga.strikepractice.api.APIClass;
import ga.strikepractice.arena.Arena;
import ga.strikepractice.arena.DefaultArena;
import ga.strikepractice.battlekit.BattleKit;
import ga.strikepractice.events.DuelEndEvent;
import ga.strikepractice.events.DuelStartEvent;
import ga.strikepractice.events.RoundEndEvent;
import ga.strikepractice.events.RoundStartEvent;
import ga.strikepractice.fightinventory.FightInventory;
import ga.strikepractice.fights.AbstractFight;
import ga.strikepractice.fights.EloChange;
import ga.strikepractice.fights.Fight;
import ga.strikepractice.fights.FightStatistics;
import ga.strikepractice.fights.duel.BestOf;
import ga.strikepractice.fights.duel.BestOfFight;
import ga.strikepractice.fights.elo.EloCalculator;
import ga.strikepractice.fights.elo.EloChanges;
import ga.strikepractice.fights.queue.QueueManager;
import ga.strikepractice.fights.savedfights.LegacySavedFight;
import ga.strikepractice.hostedevents.brackets.Brackets;
import ga.strikepractice.hostedevents.brackets.BracketsCommand;
import ga.strikepractice.matchrecorder.recorder.Recordable;
import ga.strikepractice.matchrecorder.recorder.fightrecorder.FightRecorder;
import ga.strikepractice.permissions.Permission;
import ga.strikepractice.spectator.SpectatorHandler;
import ga.strikepractice.stats.DefaultPlayerStats;
import ga.strikepractice.stats.Stats;
import ga.strikepractice.utils.CommonUtil;
import ga.strikepractice.utils.Countdown;
import ga.strikepractice.utils.MapUtil;
import ga.strikepractice.utils.PlayerUtil;
import ga.strikepractice.utils.SPDebugger;
import ga.strikepractice.utils.Scheduler;
import ga.strikepractice.utils.Teleporter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

@APIClass
public class Duel
extends AbstractFight
implements Recordable,
BestOfFight {
    public static final Map<UUID, List<EloChange>> eloFights = new HashMap<UUID, List<EloChange>>();
    private final StrikePractice plugin;
    private final String p1;
    private final String p2;
    private boolean breaktime;
    private boolean cancelled;
    private boolean doNotTeleport;
    private boolean queue;
    private boolean ended;
    private boolean premiumQueue;
    public int winnerEloChange;
    public int loserEloChange;
    private int winnerOldElo;
    private int loserOldElo;
    private FightRecorder recorder;
    private BestOf bestOf;

    public Duel(StrikePractice plugin, String p1, String p2, BattleKit kit) {
        this.plugin = plugin;
        this.p1 = p1;
        this.p2 = p2;
        this.kit = kit;
        this.handleStart();
    }

    public Duel(StrikePractice plugin, String p1, String p2) {
        this.plugin = plugin;
        this.p1 = p1;
        this.p2 = p2;
    }

    public void handleStart() {
        DuelStartEvent event = new DuelStartEvent(this, PlayerUtil.getPlayer((String)this.p1), PlayerUtil.getPlayer((String)this.p2), this.kit);
        Bukkit.getPluginManager().callEvent((Event)event);
        this.cancelled = event.isCancelled();
        this.kit = event.getKit();
        if (this.kit != null && this.bestOf == null) {
            this.bestOf = new BestOf(this.kit.getBestOf());
        }
    }

    @Override
    public void start() {
        if (!this.cancelled) {
            Fight f2;
            super.start();
            this.setStartedAfterCountdown();
            this.plugin.getFileManager().addFight(this.kit);
            Player pl1 = PlayerUtil.getPlayer((String)this.p1);
            Player pl2 = PlayerUtil.getPlayer((String)this.p2);
            Fight f1 = AbstractFight.getCurrentFight(pl1);
            boolean kicked = false;
            if (f1 != null) {
                Bukkit.getLogger().warning(pl1.getName() + " was kicked because they were in 2 different fights.");
                kicked = true;
            }
            if ((f2 = AbstractFight.getCurrentFight(pl2)) != null) {
                Bukkit.getLogger().warning(pl2.getName() + " was kicked because they were in 2 different fights.");
                kicked = true;
            }
            if (this.arena.isUsing()) {
                Bukkit.getLogger().warning("Both players were kicked because somehow the arena was already in use.");
                kicked = true;
            }
            if (kicked) {
                String err = "Fight ended (" + this.p2 + " and " + this.p1 + ") because player was already in another fight.";
                pl1.sendMessage(err);
                pl2.sendMessage(err);
                Bukkit.broadcast((String)err, (String)Permission.STAFF.getPermission());
                pl1.kickPlayer("Something went wrong... Please relog");
                pl2.kickPlayer("Something went wrong... Please relog");
                Bukkit.getLogger().warning("Some debug: ");
                Bukkit.getLogger().warning("New fight " + this);
                Bukkit.getLogger().warning("f1: " + f1 + ", f2: " + f2);
                throw new IllegalStateException(err);
            }
            QueueManager.leaveQueue((Player)pl1, (boolean)true);
            QueueManager.leaveQueue((Player)pl2, (boolean)true);
            DefaultPlayerStats stats1 = DefaultPlayerStats.getStats((UUID)pl1.getUniqueId(), (boolean)true, (boolean)true);
            DefaultPlayerStats stats2 = DefaultPlayerStats.getStats((UUID)pl2.getUniqueId(), (boolean)true, (boolean)true);
            if (this.premiumQueue) {
                stats1.setPremiumMatches(stats1.getPremiumMatches() - 1);
                stats2.setPremiumMatches(stats2.getPremiumMatches() - 1);
            } else if (this.queue) {
                if (this.kit.isElo()) {
                    if (this.plugin.getConfig().getBoolean("limit-rankeds")) {
                        stats1.removeRanked();
                        stats2.removeRanked();
                    }
                } else if (this.plugin.getConfig().getBoolean("limit-unrankeds")) {
                    stats1.removeUnranked();
                    stats2.removeUnranked();
                }
            }
            this.startRound(pl1, pl2, false);
            this.plugin.sendMessage(pl1, "fight-start-message.duel", MapUtil.mapOf((Object[])new Object[]{"<opponent>", pl2.getName()}));
            this.plugin.sendMessage(pl2, "fight-start-message.duel", MapUtil.mapOf((Object[])new Object[]{"<opponent>", pl1.getName()}));
            this.kit.sendFightInfo(pl1);
            this.kit.sendFightInfo(pl2);
            if (this.kit.isElo()) {
                int pl1Elo = stats1.getElo(this.kit);
                int pl2Elo = stats2.getElo(this.kit);
                this.plugin.sendMessage(pl1, "fight-start-message.elo", MapUtil.mapOf((Object[])new Object[]{"<your_elo>", pl1Elo, "<opponent_elo>", pl2Elo, "<you>", pl1.getName(), "<opponent>", pl2.getName()}));
                this.plugin.sendMessage(pl2, "fight-start-message.elo", MapUtil.mapOf((Object[])new Object[]{"<your_elo>", pl2Elo, "<opponent_elo>", pl1Elo, "<you>", pl2.getName(), "<opponent>", pl1.getName()}));
                if (this.plugin.getConfig().getBoolean("record-elo-fights")) {
                    this.recorder = new FightRecorder((Fight)this, Arrays.asList(pl1.getUniqueId(), pl2.getUniqueId()));
                    this.recorder.startRecording();
                }
            }
            if (this.recorder == null && this.plugin.getConfig().getBoolean("record-all-fights")) {
                this.recorder = new FightRecorder((Fight)this, Arrays.asList(pl1.getUniqueId(), pl2.getUniqueId()));
                this.recorder.startRecording();
            }
        }
    }

    @Override
    public boolean allowSpectating() {
        return !this.plugin.getConfig().getBoolean("no-duel-spectating");
    }

    @Override
    public void setArena(Arena arena) {
        this.arena = arena;
    }

    @Override
    public void setKit(BattleKit kit) {
        this.kit = kit;
    }

    @Override
    public boolean hasEnded() {
        return this.ended;
    }

    @Override
    public boolean canStart() {
        if (this.arena == null) {
            this.arena = this.kit != null && this.kit.isBuild() ? DefaultArena.findEmptyBuildArena((Player)PlayerUtil.getPlayer((String)this.p1), (BattleKit)this.kit) : DefaultArena.findEmptyArena((Player)PlayerUtil.getPlayer((String)this.p1), (BattleKit)this.kit);
        }
        return this.p1 != null && this.p2 != null && this.arena != null && !this.arena.needsRollback() && !this.arena.isUsing() && this.arena.getLoc1() != null && this.arena.getLoc2() != null && this.arena.getLoc1().getWorld() != null;
    }

    @Override
    public void handleDeath(Player p2) {
        Player opponent;
        SPDebugger.debug((String)(p2.getName() + " handling death in " + this));
        if (this.ended || this.breaktime) {
            SPDebugger.debug((String)(p2.getName() + " died but not handled because ended=" + this.ended + ", breaktime=" + this.breaktime + ". This may be a bug."));
            return;
        }
        String winnerName = this.getP1();
        if (winnerName.equals(p2.getName())) {
            winnerName = this.getP2();
        }
        if ((opponent = PlayerUtil.getPlayer((String)winnerName)) == null) {
            AbstractFight.setCurrentFight(p2, null);
            this.plugin.clear(p2, true, true);
            this.arena.setUsing(false, null);
            p2.sendMessage(ChatColor.RED + "An error occurred: opponent was not found");
            Bukkit.getLogger().warning(winnerName + " player was not found. " + p2.getName() + " was teleported from fight alone: " + this);
            return;
        }
        if (this.bestOf != null && this.bestOf.getRounds() > 1) {
            boolean endingNow = this.bestOf.endsNow(p2.getUniqueId());
            Bukkit.getPluginManager().callEvent((Event)new RoundEndEvent(this, endingNow, Collections.singletonList(opponent), Collections.singletonList(p2)));
        }
        this.plugin.removeHangingPearls(p2);
        this.plugin.removeHangingPearls(opponent);
        if (this.bestOf != null && !this.bestOf.handleWin(opponent.getUniqueId())) {
            this.breaktime = true;
            this.arena.rollbackArena(this);
            SPDebugger.debug((String)"bestof duel arena resetting (if set so)...");
            new /* Unavailable Anonymous Inner Class!! */.runTaskLater((Plugin)this.plugin, this.kit.isNoBestOfRollback() || !this.kit.isBuild() ? 1L : 5L);
            return;
        }
        SPDebugger.debug((String)("Ending fight " + this));
        this.ended = true;
        ((AbstractFight)this).ended = System.currentTimeMillis();
        Bukkit.getPluginManager().callEvent((Event)new DuelEndEvent(this, opponent, p2));
        FightInventory inv = new FightInventory(p2, this.plugin);
        FightInventory inv2 = new FightInventory(opponent, this.plugin);
        inv.setNextInventory(inv2);
        inv2.setNextInventory(inv);
        this.plugin.clear(p2, !this.allowSpectating() || this.kit.isBedwars() || this.kit.isBridges() || this.kit.isParkour(), true);
        if (this.plugin.getTagManager().coloredTagsEnabled) {
            this.plugin.getTagManager().removeFromTeams(p2);
            this.plugin.getTagManager().removeFromTeams(opponent);
        }
        UUID pUUID = p2.getUniqueId();
        UUID oUUID = opponent.getUniqueId();
        SpectatorHandler spectators = this.plugin.getSpectatorHandler();
        if (!this.doNotTeleport) {
            new /* Unavailable Anonymous Inner Class!! */.runTaskLater((Plugin)this.plugin, 20L * (long)this.plugin.getConfig().getInt("wait-before-teleport") + 1L);
        } else {
            if (spectators.isSpectator(p2)) {
                spectators.removeSpectator(p2, false);
            }
            this.plugin.clear(opponent, false, true);
            this.arena.setUsing(false, null);
        }
        Scheduler.asyncIf((boolean)this.plugin.getConfig().getBoolean("async-match-end"), () -> {
            this.plugin.sendMessage(opponent, "you-won", MapUtil.mapOf((Object[])new Object[]{"<loser>", p2.getName(), "<winner>", opponent.getName()}));
            this.plugin.sendMessage(p2, "did-not-win", MapUtil.mapOf((Object[])new Object[]{"<loser>", p2.getName(), "<winner>", opponent.getName(), "<health>", Math.round(inv2.getHealth())}));
            if (this.kit.isElo()) {
                p2.setMetadata("StrikePracticeEloFightsCooldown", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)System.currentTimeMillis()));
                opponent.setMetadata("StrikePracticeEloFightsCooldown", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)System.currentTimeMillis()));
                int opponentELO = DefaultPlayerStats.getStats((UUID)oUUID).getElo(this.kit);
                int result2 = DefaultPlayerStats.getStats((UUID)pUUID).getElo(this.kit);
                this.doElo(opponent, opponentELO, p2, result2);
            }
            if (this.plugin.getConfig().getBoolean("clickable-messages")) {
                FightInventory.duelMessage(opponent, p2, inv2, inv);
            }
            AbstractFight.setCurrentFight(p2, null);
            if (this.doNotTeleport) {
                AbstractFight.setCurrentFight(opponent, null);
            }
            if (this.isQueue()) {
                p2.setMetadata("StrikePracticeQueueFightsCooldown", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)System.currentTimeMillis()));
                opponent.setMetadata("StrikePracticeQueueFightsCooldown", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)System.currentTimeMillis()));
            }
            boolean fightLink = this.plugin.getConfig().getBoolean("match-link-after-fight");
            String linkMessage = null;
            if (fightLink) {
                linkMessage = CommonUtil.translateColors((String)this.plugin.getConfig().getString("match-link")).replace("<ended>", Long.toString(this.getEnded())).replace("<started>", Long.toString(this.getStarted()));
                p2.sendMessage(linkMessage);
                opponent.sendMessage(linkMessage);
            }
            this.sendSpectatorMessages(Collections.singleton(opponent.getName()), Collections.singleton(p2.getName()), linkMessage);
            boolean save = this.plugin.getConfig().getBoolean("save-all-fights") || this.kit.isElo() && this.plugin.getConfig().getBoolean("save-elo-fights");
            SPDebugger.debug((String)("fight saving enabled: " + save));
            if (this.recorder != null && this.recorder.getRecordedMatch() != null && this.recorder.hasStartedRecording()) {
                new /* Unavailable Anonymous Inner Class!! */.runTaskLaterAsynchronously((Plugin)this.plugin, 40L);
            } else if (save) {
                SPDebugger.debug((String)"Saving without replays...");
                LegacySavedFight savedFight = this.saveFight(Arrays.asList(oUUID), Arrays.asList(pUUID), Arrays.asList(inv2), Arrays.asList(inv), null);
                this.saveSavedFight(savedFight);
            }
        });
    }

    private void saveSavedFight(LegacySavedFight sf) {
        SPDebugger.debug((String)("Saving SavedFight " + sf + ", total players:" + sf.getLosers().size() + "/" + sf.getWinners().size()));
        if (StrikePractice.getInstance().mySQL == null) {
            SPDebugger.debug((String)"Never mind, SQL database is disabled...");
            return;
        }
        if (this.plugin.getConfig().getBoolean("legacy-fight-format")) {
            SPDebugger.debug((String)"Saving legacy");
            sf.saveToDatabase();
        } else {
            SPDebugger.debug((String)"Saving non-legacy");
            sf.toNewSavedFightFormat().saveToDatabase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceEnd(String reason) {
        try {
            if (this.p1 != null) {
                Player player1 = PlayerUtil.getPlayer((String)this.p1);
                this.sendEndReasonAndClear(reason, player1);
            }
            if (this.p2 != null) {
                Player p2 = PlayerUtil.getPlayer((String)this.p2);
                this.sendEndReasonAndClear(reason, p2);
            }
            Bukkit.getPluginManager().callEvent((Event)new DuelEndEvent(this, null, null));
            Brackets brackets = BracketsCommand.brackets;
            if (brackets != null && (brackets.getP1() != null && brackets.getP1().equals(this.p1) || brackets.getP1() != null && brackets.getP1().equals(this.p2) || brackets.getP2() != null && brackets.getP2().equals(this.p1) || brackets.getP2() != null && brackets.getP2().equals(this.p2))) {
                if (reason != null) {
                    for (String s2 : brackets.getPlayers().keySet()) {
                        Player pl = PlayerUtil.getPlayer((String)s2);
                        if (pl == null || reason == null) continue;
                        pl.sendMessage(reason);
                    }
                }
                brackets.stop();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            this.arena.setUsing(false, null);
            this.ended = true;
            ((AbstractFight)this).ended = System.currentTimeMillis();
        }
    }

    private void sendEndReasonAndClear(String reason, Player p1) {
        if (p1 != null) {
            if (reason != null) {
                p1.sendMessage(reason);
            }
            AbstractFight.setCurrentFight(p1, null);
            this.plugin.clear(p1, true, true, true);
            if (this.plugin.getTagManager().coloredTagsEnabled) {
                this.plugin.getTagManager().removeFromTeams(p1);
            }
        }
    }

    @Override
    public LegacySavedFight saveFight(List<UUID> winners, List<UUID> losers, List<FightInventory> winnersInventories, List<FightInventory> losersInventories, UUID playbackUUID) {
        LegacySavedFight sf = new LegacySavedFight();
        sf.getWinners().put(winners.get(0), Bukkit.getOfflinePlayer((UUID)winners.get(0)).getName());
        sf.getLosers().put(losers.get(0), Bukkit.getOfflinePlayer((UUID)losers.get(0)).getName());
        sf.setArena(this.arena.getDisplayName());
        sf.setKit(this.kit.getName());
        sf.setCombo(this.kit.isCombo());
        sf.setElo(this.kit.isElo());
        sf.setBuild(this.kit.isBuild());
        sf.setHorse(this.kit.isHorse());
        sf.setOnlyBow(this.kit.isOnlyBow());
        sf.setLosersInventories(losersInventories);
        sf.setWinnersInventories(winnersInventories);
        sf.getLosersNewElo().add(this.loserOldElo + this.loserEloChange);
        sf.getLosersOldElo().add(this.loserOldElo);
        sf.getWinnersNewElo().add(this.winnerOldElo + this.winnerEloChange);
        sf.getWinnersOldElo().add(this.winnerOldElo);
        sf.setStarted(this.getStarted());
        sf.setEnded(this.getEnded());
        sf.setPlaybackUUID(playbackUUID);
        this.createSavedFight(winners, sf);
        this.createSavedFight(losers, sf);
        sf.fightStatistics = this.getFightStatistics();
        return sf;
    }

    @Override
    public List<String> getTeammates(Player p2) {
        return Collections.singletonList(p2.getName());
    }

    @Override
    public List<String> getOpponents(Player p2) {
        return Collections.singletonList(p2.getName().equals(this.p1) ? this.p2 : this.p1);
    }

    @Override
    public boolean playersAreTeammates(Player one, Player two) {
        return false;
    }

    @Override
    public boolean playersAreOpponents(Player one, Player two) {
        if (one.getName().equals(this.p1) && two.getName().equals(this.p2)) {
            return true;
        }
        return two.getName().equals(this.p1) && one.getName().equals(this.p2);
    }

    private void createSavedFight(List<UUID> uuids, LegacySavedFight sf) {
        for (UUID uuid : uuids) {
            FightStatistics stats = this.getStatistics(uuid);
            sf.getHits().add(stats.getHits());
            sf.getLongestCombo().add(stats.getLongestCombo());
            sf.getPotionsThrown().add(stats.getPotionsThrown());
            sf.getPotionsMissed().add(stats.getPotionsMissed());
            sf.getPotionAccuracy().add(stats.getAccuracy());
        }
    }

    private void startRound(Player pl1, Player pl2, boolean syncTeleport) {
        Bukkit.getPluginManager().callEvent((Event)new RoundStartEvent(this));
        if (pl1.isDead()) {
            pl1.spigot().respawn();
        }
        if (pl2.isDead()) {
            pl2.spigot().respawn();
        }
        this.plugin.clear(pl1, false, false);
        this.plugin.clear(pl2, false, false);
        this.arena.setUsing(true, this);
        if (this.plugin.getTagManager().coloredTagsEnabled) {
            this.plugin.getTagManager().setTagToUUIDS(pl1, "team2", Collections.singletonList(pl2.getUniqueId()));
            this.plugin.getTagManager().setTagToUUIDS(pl2, "team2", Collections.singletonList(pl1.getUniqueId()));
            this.plugin.getTagManager().setTagToUUIDS(pl1, "team1", Collections.singletonList(pl1.getUniqueId()));
            this.plugin.getTagManager().setTagToUUIDS(pl2, "team1", Collections.singletonList(pl2.getUniqueId()));
        }
        if (!Teleporter.teleport((Player)pl1, (Location)this.arena.getLoc1(), (boolean)syncTeleport) || !Teleporter.teleport((Player)pl2, (Location)this.arena.getLoc2(), (boolean)syncTeleport)) {
            this.forceEndDelayed(ChatColor.RED + "An error occurred in your fight and the fight was forced to end!");
            return;
        }
        pl1.hidePlayer(pl2);
        pl2.hidePlayer(pl1);
        pl1.showPlayer(pl2);
        pl2.showPlayer(pl1);
        this.kit.giveKit(pl1);
        this.kit.giveKit(pl2);
        this.startCountdown();
        pl1.updateInventory();
        pl2.updateInventory();
        AbstractFight.setCurrentFight(pl1, this);
        AbstractFight.setCurrentFight(pl2, this);
        if (this.bestOf != null && this.bestOf.getRounds() > 1) {
            this.bestOf.message(pl1, pl2);
        }
        if (this.kit.isBedwars()) {
            this.bed2Broken = false;
            this.bed1Broken = false;
        }
    }

    private void startCountdown() {
        Countdown.startCountdown(Arrays.asList(this.p1, this.p2), (this.kit == null || this.kit.isStickSpawn() ? 1 : 0) != 0);
    }

    private void doElo(Player winner, int winnerElo, Player loser, int loserElo) {
        this.winnerOldElo = winnerElo;
        this.loserOldElo = loserElo;
        EloChanges changes = new EloChanges(this.winnerOldElo, this.loserOldElo, this.winnerOldElo, this.loserOldElo);
        EloCalculator.getEloCalculator().calculateElo(changes);
        int winnerNewElo = changes.getWinnerNewElo();
        int loserNewElo = changes.getLoserNewElo();
        int winnerChange = changes.getWinnerChange();
        int loserChange = changes.getLoserChange();
        this.winnerEloChange = winnerChange;
        this.loserEloChange = loserChange;
        UUID winnerUUID = winner.getUniqueId();
        UUID loserUUID = loser.getUniqueId();
        DefaultPlayerStats winnerStats = DefaultPlayerStats.getStats((UUID)winnerUUID);
        DefaultPlayerStats loserStats = DefaultPlayerStats.getStats((UUID)loserUUID);
        if (this.plugin.getConfig().getBoolean("elo-is-global-elo")) {
            this.plugin.kits.forEach(kit -> {
                if (kit.isElo()) {
                    winnerStats.getElos().put(Stats.eloColumn((BattleKit)kit), winnerNewElo);
                    loserStats.getElos().put(Stats.eloColumn((BattleKit)kit), loserNewElo);
                }
            });
        } else {
            winnerStats.getElos().put(Stats.eloColumn((BattleKit)this.kit), winnerNewElo);
            loserStats.getElos().put(Stats.eloColumn((BattleKit)this.kit), loserNewElo);
        }
        this.sendEloChangeMsg(winner, loser, winnerElo, loserElo, winnerNewElo, loserNewElo, winnerChange, loserChange, loser.getName());
        this.sendEloChangeMsg(winner, winner, winnerElo, loserElo, winnerNewElo, loserNewElo, winnerChange, loserChange, loser.getName());
        this.saveEloHistory(winnerUUID, winnerChange);
        this.saveEloHistory(loserUUID, loserChange);
    }

    private void sendEloChangeMsg(Player opponent, Player p2, int old1, int old2, int k2, int m2, int diff1, int diff2, String name) {
        this.plugin.sendMessage(p2, "elo-fight", MapUtil.mapOf((Object[])new Object[]{"<player1>", opponent.getName(), "<player2>", name, "<elo1>", k2, "<elo2>", m2, "<old1>", old1, "<old2>", old2, "<diff1>", diff1, "<diff2>", diff2}));
    }

    private void saveEloHistory(UUID pUUID, int diff2) {
        List eloHistory2 = eloFights.getOrDefault(pUUID, new ArrayList());
        if (eloHistory2.size() >= 10) {
            eloHistory2.remove(0);
        }
        eloHistory2.add(new EloChange(this.kit, diff2));
        eloFights.put(pUUID, eloHistory2);
    }

    @Override
    public FightRecorder getRecorder() {
        return this.recorder;
    }

    public String getP1() {
        return this.p1;
    }

    public boolean isPremiumQueue() {
        return this.premiumQueue;
    }

    public void setPremiumQueue(boolean premiumQueue) {
        this.premiumQueue = premiumQueue;
    }

    public String getP2() {
        return this.p2;
    }

    @Override
    public BestOf getBestOf() {
        return this.bestOf;
    }

    @Override
    public void setBestOf(BestOf bestOf) {
        this.bestOf = bestOf;
    }

    public boolean isQueue() {
        return this.queue;
    }

    public void setQueue(boolean queue) {
        this.queue = queue;
    }

    public boolean isDoNotTeleport() {
        return this.doNotTeleport;
    }

    public void setDoNotTeleport(boolean doNotTeleport) {
        this.doNotTeleport = doNotTeleport;
    }

    @Override
    public boolean isBreakTime() {
        return this.breaktime;
    }

    @Deprecated
    public String toString() {
        return "Duel{p1='" + this.p1 + '\'' + ", p2='" + this.p2 + '\'' + ", breaktime=" + this.breaktime + ", cancelled=" + this.cancelled + ", doNotTeleport=" + this.doNotTeleport + ", queue=" + this.queue + ", ended=" + this.ended + ", premiumQueue=" + this.premiumQueue + ", winnerEloChange=" + this.winnerEloChange + ", loserEloChange=" + this.loserEloChange + ", winnerOldElo=" + this.winnerOldElo + ", loserOldElo=" + this.loserOldElo + '}';
    }

    static /* synthetic */ String access$000(Duel x0) {
        return x0.p1;
    }

    static /* synthetic */ String access$100(Duel x0) {
        return x0.p2;
    }

    static /* synthetic */ void access$200(Duel x0, Player x1, Player x2, boolean x3) {
        x0.startRound(x1, x2, x3);
    }

    static /* synthetic */ boolean access$302(Duel x0, boolean x1) {
        x0.breaktime = x1;
        return x0.breaktime;
    }

    static /* synthetic */ Arena access$400(Duel x0) {
        return x0.arena;
    }

    static /* synthetic */ StrikePractice access$500(Duel x0) {
        return x0.plugin;
    }

    static /* synthetic */ FightRecorder access$600(Duel x0) {
        return x0.recorder;
    }

    static /* synthetic */ void access$700(Duel x0, LegacySavedFight x1) {
        x0.saveSavedFight(x1);
    }
}

