/*
 * Decompiled with CFR 0.152.
 */
package ga.strikepractice.fights.duel;

import ga.strikepractice.StrikePractice;
import ga.strikepractice.api.APIClass;
import ga.strikepractice.utils.MapUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;

@APIClass
public class BestOf {
    public static final int TICKS_BEFORE_NEXT_ROUND = 5;
    private int currentRound = 1;
    private final int rounds;
    private final Map<UUID, Integer> wins = new HashMap<UUID, Integer>(2);

    public BestOf(int rounds) {
        this.rounds = rounds;
    }

    public boolean handleWin(UUID uuid) {
        int i2 = this.wins.getOrDefault(uuid, 0) + 1;
        this.wins.put(uuid, i2);
        int x2 = this.rounds / 2;
        ++this.currentRound;
        return i2 > x2;
    }

    public void message(Player p1, Player p2) {
        StrikePractice plugin = StrikePractice.getInstance();
        this.sendMessage(p1, p2);
        this.sendMessage(p2, p1);
    }

    private void sendMessage(Player toSend, Player other) {
        StrikePractice.getInstance().sendMessage(toSend, "best-of-round", MapUtil.mapOf((Object[])new Object[]{"<player1>", toSend.getName(), "<player2>", other.getName(), "<total_rounds>", this.rounds, "<round>", this.currentRound, "<player1_wins>", this.wins.getOrDefault(toSend.getUniqueId(), 0), "<player2_wins>", this.wins.getOrDefault(other.getUniqueId(), 0)}));
    }

    public void message(Player p1, UUID fakeBotUUIDForBestOf, String name2) {
        StrikePractice plugin = StrikePractice.getInstance();
        plugin.sendMessage(p1, "best-of-round", MapUtil.mapOf((Object[])new Object[]{"<player1>", p1.getName(), "<player2>", name2, "<total_rounds>", this.rounds, "<round>", this.currentRound, "<player1_wins>", this.wins.getOrDefault(p1.getUniqueId(), 0), "<player2_wins>", this.wins.getOrDefault(fakeBotUUIDForBestOf, 0)}));
    }

    public int getRounds() {
        return this.rounds;
    }

    public int getCurrentRound() {
        return this.currentRound;
    }

    @Deprecated
    public HashMap<UUID, Integer> getWins() {
        return (HashMap)this.wins;
    }

    public Map<UUID, Integer> getRoundsWon() {
        return this.wins;
    }

    public int getWins(Player p2) {
        return this.wins.getOrDefault(p2.getUniqueId(), 0);
    }

    public int getBotWins(Player p2) {
        for (Map.Entry<UUID, Integer> e2 : this.wins.entrySet()) {
            if (p2.getUniqueId().equals(e2.getKey())) continue;
            return e2.getValue();
        }
        return 0;
    }

    public boolean endsNow(UUID dead) {
        if (this.rounds == 1) {
            return true;
        }
        for (Map.Entry<UUID, Integer> e2 : this.wins.entrySet()) {
            int toWin;
            if (e2.getKey().equals(dead)) continue;
            int wins = e2.getValue();
            return wins + 1 > (toWin = this.rounds / 2);
        }
        return false;
    }

    public String toString() {
        return "BestOf{currentRound=" + this.currentRound + ", rounds=" + this.rounds + ", wins=" + this.wins + '}';
    }
}

