/*
 * Decompiled with CFR 0.152.
 */
package ga.strikepractice.fights.botduel;

import ga.strikepractice.StrikePractice;
import ga.strikepractice.api.APIClass;
import ga.strikepractice.arena.Arena;
import ga.strikepractice.arena.DefaultArena;
import ga.strikepractice.battlekit.BattleKit;
import ga.strikepractice.bot.PracticeBot;
import ga.strikepractice.events.BotDuelEndEvent;
import ga.strikepractice.events.BotDuelStartEvent;
import ga.strikepractice.events.RoundEndEvent;
import ga.strikepractice.events.RoundStartEvent;
import ga.strikepractice.fightinventory.FightInventory;
import ga.strikepractice.fights.AbstractFight;
import ga.strikepractice.fights.BotFight;
import ga.strikepractice.fights.Fight;
import ga.strikepractice.fights.duel.BestOf;
import ga.strikepractice.fights.duel.BestOfFight;
import ga.strikepractice.fights.queue.QueueManager;
import ga.strikepractice.matchrecorder.recorder.Recordable;
import ga.strikepractice.matchrecorder.recorder.fightrecorder.FightRecorder;
import ga.strikepractice.npc.CitizensNPC;
import ga.strikepractice.utils.CommonUtil;
import ga.strikepractice.utils.Countdown;
import ga.strikepractice.utils.MapUtil;
import ga.strikepractice.utils.PlayerUtil;
import ga.strikepractice.utils.SPDebugger;
import ga.strikepractice.utils.Scheduler;
import ga.strikepractice.utils.Teleporter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.metadata.Metadatable;
import org.bukkit.plugin.Plugin;

@APIClass
public class BotDuel
extends AbstractFight
implements BotFight,
Recordable,
BestOfFight {
    private final StrikePractice plugin;
    private final String p1;
    private String botName;
    private PracticeBot p2;
    private boolean ended;
    private String difficulty;
    private BestOf bestOf;
    private UUID fakeBotUUIDForBestOf;
    private boolean breaktime;
    private FightRecorder recorder;

    public BotDuel(StrikePractice plugin, String p1, BattleKit kit) {
        this.plugin = plugin;
        this.p1 = p1;
        this.kit = kit;
        if (kit != null) {
            this.bestOf = new BestOf(kit.getBestOf());
            this.fakeBotUUIDForBestOf = UUID.randomUUID();
        }
    }

    @Override
    public boolean canStart() {
        if (this.arena == null) {
            this.arena = this.kit.isBuild() ? DefaultArena.findEmptyBuildArena((Player)Bukkit.getPlayer((String)this.p1), (BattleKit)this.kit) : DefaultArena.findEmptyArena((Player)Bukkit.getPlayer((String)this.p1), (BattleKit)this.kit);
        }
        return this.p1 != null && this.arena != null && !this.arena.needsRollback() && !this.arena.isUsing() && this.arena.getLoc1() != null && this.arena.getLoc2() != null && this.arena.getLoc1().getWorld() != null && this.arena.getLoc1().getWorld().getName().equals(this.arena.getLoc2().getWorld().getName());
    }

    @Override
    public void start() {
        super.start();
        Player pl1 = PlayerUtil.getPlayer((String)this.p1);
        this.setStartedAfterCountdown();
        QueueManager.leaveQueue((Player)pl1, (boolean)true);
        if (this.plugin.getSpectatorHandler().isSpectator(pl1)) {
            this.plugin.getSpectatorHandler().removeSpectator(pl1, false);
        }
        if (pl1.isDead()) {
            pl1.spigot().respawn();
        }
        this.plugin.clear(pl1, false, false);
        this.arena.setUsing(true, this);
        this.doStuff(pl1);
        BotDuelStartEvent event = new BotDuelStartEvent(this, pl1, this.p2);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.plugin.getFileManager().addFight(this.kit);
        this.plugin.sendMessage(pl1, "fight-start-message.duel", MapUtil.mapOf((Object[])new Object[]{"<opponent>", this.getP2().getNPC().getName()}));
        this.kit.sendFightInfo(pl1);
        if (this.recorder == null && this.plugin.getConfig().getBoolean("record-all-fights")) {
            this.recorder = new FightRecorder((Fight)this, Collections.singletonList(pl1.getUniqueId()), Collections.singletonList(this.getP2()));
            new /* Unavailable Anonymous Inner Class!! */.runTaskLater((Plugin)this.plugin, 100L);
        }
    }

    private void doStuff(Player pl1) {
        if (!Teleporter.teleport((Player)pl1, (Location)this.arena.getLoc1())) {
            this.forceEndDelayed(ChatColor.RED + "An error occurred in your fight and the fight was forced to end!");
            return;
        }
        Bukkit.getPluginManager().callEvent((Event)new RoundStartEvent(this));
        pl1.setHealth(pl1.getMaxHealth());
        pl1.setFoodLevel(20);
        pl1.setFireTicks(0);
        this.kit.giveKit(pl1);
        this.p2 = this.plugin.getBotManager().shouldUseModern() ? this.plugin.getBotManager().createModernBot(this.difficulty, this.arena.getLoc2(), Collections.singletonList(pl1.getUniqueId()), (Fight)this) : this.plugin.getBotManager().createLegacyBot(CommonUtil.translateColors((String)this.plugin.getConfig().getString("bot-name").replace("<player>", pl1.getName())), pl1.getName(), this.arena.getLoc2(), (Fight)this, Collections.singletonList(pl1.getUniqueId()), CitizensNPC.Difficulty.of(this.difficulty));
        if (this.p2 != null) {
            this.botName = ChatColor.stripColor((String)this.p2.getNPC().getName());
        }
        this.startCountdown();
        AbstractFight.setCurrentFight(pl1, this);
        pl1.updateInventory();
        if (this.bestOf != null && this.bestOf.getRounds() > 1) {
            this.bestOf.message(pl1, this.fakeBotUUIDForBestOf, this.getP2().getNPC().getName());
        }
        if (this.kit.isBedwars()) {
            this.bed2Broken = false;
            this.bed1Broken = false;
        }
    }

    private void startCountdown() {
        Countdown.startCountdown(Collections.singletonList(this.p1), (this.kit == null || this.kit.isStickSpawn() ? 1 : 0) != 0);
    }

    @Override
    public void handleDeath(Player p2) {
        try {
            FightInventory inv2;
            FightInventory inv;
            block11: {
                if (this.ended || this.breaktime) {
                    return;
                }
                if (this.bestOf != null && this.bestOf.getRounds() > 1) {
                    boolean endingNow = this.bestOf.endsNow(p2.getUniqueId());
                    Bukkit.getPluginManager().callEvent((Event)new RoundEndEvent(this, endingNow, Collections.singletonList(this.getP2().getBukkitEntity()), Collections.singletonList(p2)));
                }
                if (this.bestOf != null && !this.bestOf.handleWin(this.fakeBotUUIDForBestOf)) {
                    this.breaktime = true;
                    this.p2.destroy();
                    this.arena.rollbackArena(this);
                    new /* Unavailable Anonymous Inner Class!! */.runTaskLater((Plugin)this.plugin, this.kit.isNoBestOfRollback() || !this.kit.isBuild() ? 1L : 5L);
                    return;
                }
                this.ended = true;
                ((AbstractFight)this).ended = System.currentTimeMillis();
                Bukkit.getPluginManager().callEvent((Event)new BotDuelEndEvent(this, p2, this.getP2(), this.getP2().getNPC().getName(), BotDuelEndEvent.WinnerType.BOT));
                inv = new FightInventory(p2, this.plugin);
                inv2 = null;
                try {
                    inv2 = new FightInventory((Entity)this.getP2().getBukkitEntity(), this.getP2().getNPC().getName(), this.getP2().getBukkitEntity().getInventory(), this.plugin);
                }
                catch (Exception e2) {
                    if (!SPDebugger.getDEBUG()) break block11;
                    e2.printStackTrace();
                }
            }
            try {
                this.getP2().destroy();
            }
            catch (Exception e3) {
                Bukkit.getLogger().warning("Failed to destroy bot");
                e3.printStackTrace();
            }
            if (inv2 != null) {
                inv.setNextInventory(inv2);
                inv2.setNextInventory(inv);
            }
            this.plugin.clear(p2, true, true);
            this.arena.setUsing(false, null);
            this.plugin.sendMessage(p2, "did-not-win", MapUtil.mapOf((Object[])new Object[]{"<loser>", p2.getName(), "<winner>", this.getP2().getNPC().getName(), "<health>", inv2 == null ? "--" : Double.toString(Math.round(inv2.getHealth()))}));
            if (this.plugin.getConfig().getBoolean("clickable-messages") && inv2 != null) {
                FightInventory finalInv2 = inv2;
                Scheduler.async(() -> {
                    FightInventory.duelMessage(null, p2, this.botName, p2.getName(), finalInv2, inv);
                    this.sendSpectatorMessages(Collections.singleton(this.botName), Collections.singleton(p2.getName()));
                    AbstractFight.setCurrentFight(p2, null);
                });
            }
            this.endRecording(inv, inv2, p2.getUniqueId(), this.getP2().getNPC().getUniqueId(), p2);
            this.p2 = null;
        }
        catch (Exception e4) {
            e4.printStackTrace();
        }
    }

    @Override
    public void handleBotDeath(Metadatable metadatable) {
        FightInventory inv;
        Player opponent;
        block7: {
            if (this.ended || this.breaktime) {
                return;
            }
            opponent = PlayerUtil.getPlayer((String)this.getP1());
            if (this.bestOf != null && this.bestOf.getRounds() > 0) {
                boolean endingNow = this.bestOf.endsNow(this.fakeBotUUIDForBestOf);
                Bukkit.getPluginManager().callEvent((Event)new RoundEndEvent(this, endingNow, Collections.singletonList(opponent), Collections.singletonList(this.getP2().getBukkitEntity())));
            }
            if (this.bestOf != null && !this.bestOf.handleWin(opponent.getUniqueId())) {
                this.breaktime = true;
                this.arena.rollbackArena(this);
                new /* Unavailable Anonymous Inner Class!! */.runTaskLater((Plugin)this.plugin, this.kit.isNoBestOfRollback() || !this.kit.isBuild() ? 1L : 5L);
                return;
            }
            this.ended = true;
            ((AbstractFight)this).ended = System.currentTimeMillis();
            Bukkit.getPluginManager().callEvent((Event)new BotDuelEndEvent(this, opponent, this.getP2(), opponent.getName(), BotDuelEndEvent.WinnerType.PLAYER));
            inv = null;
            try {
                Player botAsPlayer = (Player)metadatable;
                inv = new FightInventory((Entity)botAsPlayer, botAsPlayer.getName(), botAsPlayer.getInventory(), this.plugin);
            }
            catch (Exception e2) {
                if (!SPDebugger.getDEBUG()) break block7;
                e2.printStackTrace();
            }
        }
        FightInventory inv2 = new FightInventory(opponent, this.plugin);
        if (inv != null && inv2 != null) {
            inv.setNextInventory(inv2);
            inv2.setNextInventory(inv);
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            this.arena.setUsing(false, null);
            if (opponent != null) {
                AbstractFight.setCurrentFight(opponent, null);
                this.plugin.clear(opponent, true, true);
            }
        }, (long)(20 * this.plugin.getConfig().getInt("wait-before-teleport")));
        this.plugin.sendMessage(opponent, "you-won", MapUtil.mapOf((Object[])new Object[]{"<loser>", this.getP2().getNPC().getName(), "<winner>", opponent.getName()}));
        if (this.plugin.getConfig().getBoolean("clickable-messages") && inv != null) {
            FightInventory finalInv = inv;
            Scheduler.async(() -> {
                FightInventory.duelMessage(opponent, null, opponent.getName(), this.botName, inv2, finalInv);
                this.sendSpectatorMessages(Collections.singleton(opponent.getName()), Collections.singleton(this.botName));
            });
        }
        this.endRecording(inv, inv2, this.getP2().getNPC().getUniqueId(), opponent.getUniqueId(), opponent);
        this.getP2().destroy();
        this.p2 = null;
    }

    private void endRecording(FightInventory inv, FightInventory inv2, UUID pUUID, UUID oUUID, Player human) {
        SPDebugger.debug((String)("Recording ending soon: " + this.recorder));
        if (this.recorder != null && this.recorder.getRecordedMatch() != null && this.recorder.hasStartedRecording()) {
            new /* Unavailable Anonymous Inner Class!! */.runTaskLater((Plugin)this.plugin, 40L);
        }
    }

    @Override
    public void forceEnd(String reason) {
        Player p1 = PlayerUtil.getPlayer((String)this.p1);
        Bukkit.getPluginManager().callEvent((Event)new BotDuelEndEvent(this, p1, this.getP2(), null, null));
        this.arena.setUsing(false, null);
        try {
            if (this.getP2().isLegacy()) {
                ((CitizensNPC)this.getP2()).destroy(true);
            } else {
                this.getP2().destroy();
            }
        }
        catch (Exception e2) {
            Bukkit.getLogger().warning("Failed to destroy bot (forceEnd)");
            e2.printStackTrace();
        }
        if (p1 != null) {
            if (reason != null) {
                p1.sendMessage(reason);
            }
            AbstractFight.setCurrentFight(p1, null);
            this.plugin.clear(p1, true, true, true);
        }
        this.p2 = null;
        this.ended = true;
        ((AbstractFight)this).ended = System.currentTimeMillis();
    }

    @Override
    public boolean allowSpectating() {
        return false;
    }

    @Override
    public boolean hasEnded() {
        return this.ended;
    }

    @Override
    public void setArena(Arena arena) {
        this.arena = arena;
    }

    @Override
    public void setBestOf(BestOf bestOf) {
        this.bestOf = bestOf;
    }

    @Override
    public BestOf getBestOf() {
        return this.bestOf;
    }

    @Override
    public boolean isBreakTime() {
        return this.breaktime;
    }

    public String getP1() {
        return this.p1;
    }

    public String getBotName() {
        return this.botName;
    }

    public PracticeBot getP2() {
        return this.p2;
    }

    @Override
    public String difficulty() {
        return this.difficulty;
    }

    @Override
    public CitizensNPC.Difficulty getDifficulty() {
        return CitizensNPC.Difficulty.of(this.difficulty);
    }

    @Override
    public void setDifficulty(String difficulty) {
        this.difficulty = difficulty.toLowerCase(Locale.ENGLISH);
    }

    @Override
    public FightRecorder getRecorder() {
        return this.recorder;
    }

    @Override
    public List<String> getTeammates(Player p2) {
        return Collections.singletonList(p2.getName());
    }

    @Override
    public List<String> getOpponents(Player p2) {
        return Collections.singletonList(this.botName);
    }

    @Override
    public boolean playersAreTeammates(Player one, Player two) {
        return false;
    }

    @Override
    public Collection<PracticeBot> getBots() {
        return Collections.singletonList(this.getP2());
    }

    static /* synthetic */ FightRecorder access$000(BotDuel x0) {
        return x0.recorder;
    }

    static /* synthetic */ String access$100(BotDuel x0) {
        return x0.p1;
    }

    static /* synthetic */ void access$200(BotDuel x0, Player x1) {
        x0.doStuff(x1);
    }

    static /* synthetic */ boolean access$302(BotDuel x0, boolean x1) {
        x0.breaktime = x1;
        return x0.breaktime;
    }

    static /* synthetic */ PracticeBot access$400(BotDuel x0) {
        return x0.p2;
    }

    static /* synthetic */ StrikePractice access$500(BotDuel x0) {
        return x0.plugin;
    }
}

