/*
 * Decompiled with CFR 0.152.
 */
package ga.strikepractice.fights;

import com.google.gson.annotations.SerializedName;
import ga.strikepractice.api.APIClass;
import java.io.Serializable;

@APIClass
public class FightStatistics
implements Serializable {
    @SerializedName(value="kits")
    private int hits;
    @SerializedName(value="currentCombo")
    private int currentCombo;
    @SerializedName(value="longestCombo")
    private int longestCombo;
    @SerializedName(value="potionsThrown")
    private int potionsThrown;
    @SerializedName(value="potionsMissed")
    private int potionsMissed;
    @SerializedName(value="potionIntensities")
    private double potionIntensities;
    private transient long lastHit;

    public FightStatistics() {
    }

    public FightStatistics(int hits, int longestCombo, int potionsThrow, int potionsMissed, double potionIntensities) {
        this.hits = hits;
        this.longestCombo = longestCombo;
        this.potionsThrown = potionsThrow;
        this.potionsMissed = potionsMissed;
        this.potionIntensities = potionIntensities;
    }

    public int getHits() {
        return this.hits;
    }

    public void setHits(int hits) {
        this.hits = hits;
    }

    public int getCurrentCombo() {
        return this.currentCombo;
    }

    public void setCurrentCombo(int currentCombo) {
        this.currentCombo = currentCombo;
        if (currentCombo > this.longestCombo) {
            this.longestCombo = currentCombo;
        }
    }

    public int getLongestCombo() {
        return this.longestCombo;
    }

    public void setLongestCombo(int longestCombo) {
        this.longestCombo = longestCombo;
    }

    public int getPotionsThrown() {
        return this.potionsThrown;
    }

    public void setPotionsThrown(int potionsThrown) {
        this.potionsThrown = potionsThrown;
    }

    public int getPotionsMissed() {
        return this.potionsMissed;
    }

    public void setPotionsMissed(int potionsMissed) {
        this.potionsMissed = potionsMissed;
    }

    public void addIntensity(double intensity) {
        this.potionIntensities += intensity;
    }

    public long getLastHit() {
        return this.lastHit;
    }

    public void setLastHit(long lastHit) {
        this.lastHit = lastHit;
    }

    public int getAccuracy() {
        int x2 = this.potionsThrown;
        if (x2 == 0) {
            return 0;
        }
        return (int)Math.round(Math.ceil(this.potionIntensities / (double)x2 * 100.0));
    }
}

