/*
 * Decompiled with CFR 0.152.
 */
package ga.strikepractice.fights;

import ga.strikepractice.StrikePractice;
import ga.strikepractice.api.APIClass;
import ga.strikepractice.arena.Arena;
import ga.strikepractice.arena.DefaultCachedBlockChange;
import ga.strikepractice.battlekit.BattleKit;
import ga.strikepractice.fightinventory.FightInventory;
import ga.strikepractice.fights.AbstractFight;
import ga.strikepractice.fights.FightStatistics;
import ga.strikepractice.fights.MatchDurationLimit;
import ga.strikepractice.fights.savedfights.LegacySavedFight;
import ga.strikepractice.utils.Scheduler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@APIClass
public interface Fight {
    public void start();

    public boolean allowSpectating();

    public Arena getArena();

    public void setArena(Arena var1);

    public void setKit(BattleKit var1);

    public FightStatistics getStatistics(UUID var1);

    public FightStatistics getStatistics(Player var1);

    @Deprecated
    public HashMap<UUID, FightStatistics> getStatistics();

    default public Map<UUID, FightStatistics> getFightStatistics() {
        return this.getStatistics();
    }

    @Nullable
    default public FightStatistics getFightStatistics(@NotNull Player p2) {
        return this.getFightStatistics().get(p2.getUniqueId());
    }

    public boolean hasEnded();

    default public boolean hasStarted() {
        return System.currentTimeMillis() > this.getStarted();
    }

    public boolean canStart();

    public void handleDeath(Player var1);

    public void forceEnd(String var1);

    default public void forceEndDelayed(String reason) {
        Scheduler.sync(() -> this.forceEnd(reason), (long)5L);
    }

    public BattleKit getKit();

    public long getStarted();

    public long getEnded();

    public void setStartedAfterCountdown();

    public long getDuration();

    @Deprecated
    public Set<DefaultCachedBlockChange> getBlockChanges();

    public Map<Location, DefaultCachedBlockChange> getBlockChangesMap();

    public MatchDurationLimit getDurationLimit();

    public boolean addBlockChange(DefaultCachedBlockChange var1);

    default public void clearBlockChanges() {
        this.getBlockChanges().clear();
    }

    @Deprecated
    default public LegacySavedFight saveFight(List<UUID> winners, List<UUID> losers, List<FightInventory> winnersInventories, List<FightInventory> losersInventories, UUID uuid) {
        return null;
    }

    default public List<Player> getPlayersInFight() {
        StrikePractice plugin = StrikePractice.getInstance();
        ArrayList<Player> res = new ArrayList<Player>(2);
        for (Player p2 : Bukkit.getOnlinePlayers()) {
            if (AbstractFight.getCurrentFight(p2) != this) continue;
            res.add(p2);
        }
        return res;
    }

    default public List<String> getPlayerNames() {
        return this.getPlayersInFight().stream().map(OfflinePlayer::getName).collect(Collectors.toList());
    }

    public List<String> getTeammates(Player var1);

    public List<String> getOpponents(Player var1);

    default public boolean playersAreTeammates(Player one, Player two) {
        return this.getTeammates(one).contains(two.getName());
    }

    default public boolean playersAreOpponents(Player one, Player two) {
        return this.getOpponents(one).contains(two.getName());
    }

    default public List<Player> getSpectators() {
        return StrikePractice.getInstance().getSpectatorHandler().getSpectating(this).stream().map(Bukkit::getPlayer).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

