/*
 * Decompiled with CFR 0.152.
 */
package ga.strikepractice.fights;

import ga.strikepractice.StrikePractice;
import ga.strikepractice.api.APIClass;
import ga.strikepractice.arena.Arena;
import ga.strikepractice.arena.CachedBlockChange;
import ga.strikepractice.arena.DefaultCachedBlockChange;
import ga.strikepractice.battlekit.BattleKit;
import ga.strikepractice.fightinventory.FightInventory;
import ga.strikepractice.fights.DefaultMatchDurationLimit;
import ga.strikepractice.fights.Fight;
import ga.strikepractice.fights.FightStatistics;
import ga.strikepractice.fights.MatchDurationLimit;
import ga.strikepractice.fights.other.FFAFight;
import ga.strikepractice.fights.party.partyfights.PartyFight;
import ga.strikepractice.party.Party;
import ga.strikepractice.utils.Scheduler;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

@APIClass
public abstract class AbstractFight
implements Fight {
    public static final String currentFight = "StrikePracticeCurrentFight";
    private static final ConcurrentMap<UUID, Fight> fights = new ConcurrentHashMap<UUID, Fight>();
    protected Map<Location, DefaultCachedBlockChange> blockChanges = new HashMap<Location, DefaultCachedBlockChange>(128);
    protected Map<UUID, FightStatistics> statistics = new HashMap<UUID, FightStatistics>(2);
    protected boolean bed1Broken;
    protected boolean bed2Broken;
    protected BattleKit kit;
    protected Arena arena;
    protected long started;
    protected long ended;
    protected boolean blockLimitReached;
    private boolean blockLimitMessageSent = false;
    protected MatchDurationLimit durationLimit;
    protected int maxBlockChanges = 0;

    protected int getMaxBlockChanges() {
        if (this.maxBlockChanges == 0) {
            int custom = StrikePractice.getInstance().getConfig().getInt("max-block-changes");
            if (custom != 0) {
                this.maxBlockChanges = custom;
            } else {
                try {
                    this.maxBlockChanges = 5000 + this.getPlayerNames().size() * 1000;
                }
                catch (Exception e2) {
                    this.maxBlockChanges = 3000;
                }
            }
        }
        return this.maxBlockChanges;
    }

    public static ConcurrentMap<UUID, Fight> getFights() {
        return fights;
    }

    @Override
    public void start() {
        this.durationLimit = new DefaultMatchDurationLimit((Fight)this, StrikePractice.getInstance());
        this.durationLimit.onFightStart();
    }

    @Override
    public Arena getArena() {
        return this.arena;
    }

    @Override
    public void setArena(Arena arena) {
        this.arena = arena;
    }

    @Override
    public void setKit(BattleKit kit) {
        this.kit = kit;
    }

    @Override
    public FightStatistics getStatistics(UUID uuid) {
        FightStatistics stats = this.statistics.get(uuid);
        if (stats != null) {
            return stats;
        }
        FightStatistics f2 = new FightStatistics();
        this.statistics.put(uuid, f2);
        return f2;
    }

    @Override
    public FightStatistics getStatistics(Player p2) {
        return this.getStatistics(p2.getUniqueId());
    }

    @Override
    public HashMap<UUID, FightStatistics> getStatistics() {
        return (HashMap)this.statistics;
    }

    @Override
    public BattleKit getKit() {
        return this.kit;
    }

    public boolean isBed1Broken() {
        return this.bed1Broken;
    }

    public boolean isBed2Broken() {
        return this.bed2Broken;
    }

    public void setBed1Broken(boolean bed1Broken) {
        this.bed1Broken = bed1Broken;
    }

    public void setBed2Broken(boolean bed2Broken) {
        this.bed2Broken = bed2Broken;
    }

    @Override
    public long getStarted() {
        return this.started;
    }

    @Override
    public long getEnded() {
        return this.ended;
    }

    @Override
    public void setStartedAfterCountdown() {
        this.started = System.currentTimeMillis() + (long)(StrikePractice.getInstance().getConfig().getInt("countdown-time") * 1000) + 1000L;
    }

    @Override
    public long getDuration() {
        if (!this.hasStarted()) {
            return 0L;
        }
        if (this.hasEnded()) {
            return this.ended - this.started;
        }
        return System.currentTimeMillis() - this.started;
    }

    @Override
    public Set<DefaultCachedBlockChange> getBlockChanges() {
        return new HashSet<DefaultCachedBlockChange>(this.blockChanges.values());
    }

    @Override
    public Map<Location, DefaultCachedBlockChange> getBlockChangesMap() {
        return this.blockChanges;
    }

    @Override
    public MatchDurationLimit getDurationLimit() {
        return this.durationLimit;
    }

    @Override
    public boolean addBlockChange(DefaultCachedBlockChange change) {
        if (!this.blockLimitReached) {
            if (change.isResetSupported()) {
                this.blockChanges.putIfAbsent(change.getLocation(), change);
                this.handleDisappear(change);
                this.blockLimitReached = this.blockChanges.size() > this.getMaxBlockChanges();
                return true;
            }
        } else if (!this.blockLimitMessageSent) {
            this.blockLimitMessageSent = true;
            for (Player p2 : this.getPlayersInFight()) {
                p2.sendMessage(StrikePractice.getInstance().getPrefix() + ChatColor.RED + ChatColor.BOLD + "THE FIGHT HAS REACHED THE BLOCK LIMIT! Players can not modify blocks anymore in this fight!");
            }
            for (Player p2 : this.getSpectators()) {
                p2.sendMessage(StrikePractice.getInstance().getPrefix() + ChatColor.RED + ChatColor.BOLD + "THE FIGHT HAS REACHED THE BLOCK LIMIT! Players can not modify blocks anymore in this fight!");
            }
        }
        return false;
    }

    protected void handleDisappear(CachedBlockChange change) {
        if (this.kit.getBlockDisappear() > 0 && this.kit.isBuild()) {
            Scheduler.sync(() -> {
                Block block;
                if (!this.hasEnded() && (block = change.getLocation().getBlock()) != null && block.getType() != null && block.getType() != Material.AIR) {
                    change.reset(true);
                    this.blockChanges.remove(change.getLocation());
                }
            }, (long)this.kit.getBlockDisappear());
        }
    }

    @Override
    public void clearBlockChanges() {
        this.blockChanges = new HashMap<Location, DefaultCachedBlockChange>(1);
        this.blockLimitReached = false;
    }

    public void setMaxBlockChanges(int maxBlockChanges) {
        this.maxBlockChanges = maxBlockChanges;
    }

    protected void sendSpectatorMessages(Collection<String> winners, Collection<String> losers, String matchLinkMessage) {
        if (winners != null && losers != null && StrikePractice.getInstance().getConfig().getBoolean("spectator-inventory-messages")) {
            Party[] parties = this instanceof PartyFight ? ((PartyFight)((Object)this)).getParties() : null;
            for (Player spec : this.getSpectators()) {
                if (parties != null && this.sameParty(spec, parties) || winners.contains(spec.getName()) || losers.contains(spec.getName())) continue;
                if (matchLinkMessage != null) {
                    spec.sendMessage(matchLinkMessage);
                }
                FightInventory.inventoryMessage(spec, winners, losers);
            }
        }
    }

    private boolean sameParty(Player p2, Party[] parties) {
        Party party = Party.getParty(p2);
        for (Party pr : parties) {
            if (party != pr) continue;
            return true;
        }
        return false;
    }

    protected void sendSpectatorMessages(Collection<String> winners, Collection<String> losers) {
        this.sendSpectatorMessages(winners, losers, null);
    }

    @Nullable
    public static Fight getCurrentFight(Player player) {
        return AbstractFight.getCurrentFight(player.getUniqueId());
    }

    public static Fight getCurrentFight(UUID uuid) {
        return (Fight)fights.get(uuid);
    }

    public static void setCurrentFight(Player player, Fight fight) {
        UUID uuid = player.getUniqueId();
        if (fight == null) {
            Fight oldFight = (Fight)fights.get(uuid);
            if (oldFight instanceof FFAFight) {
                ((FFAFight)oldFight).getPlayers().remove(uuid);
            }
            fights.remove(uuid);
        } else {
            fights.put(uuid, fight);
        }
    }

    public static boolean isInFight(Player p2) {
        return AbstractFight.getCurrentFight(p2) != null;
    }
}

