/*
 * Decompiled with CFR 0.152.
 */
package ga.strikepractice.fightinventory;

import com.google.gson.annotations.SerializedName;
import ga.strikepractice.StrikePractice;
import ga.strikepractice.api.APIClass;
import ga.strikepractice.fightinventory.FightInventoryHolder;
import ga.strikepractice.fightinventory.FightInventoryManager;
import ga.strikepractice.fights.AbstractFight;
import ga.strikepractice.fights.Fight;
import ga.strikepractice.fights.FightStatistics;
import ga.strikepractice.matchrecorder.RecordedMatch;
import ga.strikepractice.matchrecorder.recorder.Recordable;
import ga.strikepractice.matchrecorder.recorder.fightrecorder.FightRecorder;
import ga.strikepractice.matchrecorder.replay.ReplayInventoryManager;
import ga.strikepractice.permissions.Permission;
import ga.strikepractice.permissions.PermissionsManager;
import ga.strikepractice.utils.ClickableMessage;
import ga.strikepractice.utils.CommonUtil;
import ga.strikepractice.utils.EffectUtil;
import ga.strikepractice.utils.FormatUtils;
import ga.strikepractice.utils.ItemStackUtil;
import ga.strikepractice.utils.PlayerUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;

@APIClass
public class FightInventory
implements Serializable {
    private transient StrikePractice plugin;
    @SerializedName(value="owner")
    private String owner;
    @SerializedName(value="ownerUUID")
    private UUID ownerUUID;
    private transient FightStatistics statistics;
    @SerializedName(value="mainInv")
    private ItemStack[] mainInv;
    @SerializedName(value="dead")
    private boolean dead;
    @SerializedName(value="effects")
    private Collection<PotionEffect> effects;
    @SerializedName(value="food")
    private int food;
    @SerializedName(value="helmet")
    private ItemStack helmet;
    @SerializedName(value="chestplate")
    private ItemStack chestplate;
    @SerializedName(value="leggings")
    private ItemStack leggings;
    @SerializedName(value="boots")
    private ItemStack boots;
    @SerializedName(value="health")
    private double health;
    @SerializedName(value="inventoryUUID")
    private UUID inventoryUUID;
    @SerializedName(value="playbackUUID")
    private UUID playbackUUID;
    @SerializedName(value="left")
    private int left;
    @SerializedName(value="created")
    private long created;
    @SerializedName(value="leftPotions")
    private boolean leftPotions;
    private transient FightInventory nextInventory;

    public FightInventory(Player p2, StrikePractice plugin) {
        if (p2 != null) {
            Player d2 = p2;
            this.health = d2.getHealth();
            this.helmet = p2.getInventory().getHelmet();
            this.chestplate = p2.getInventory().getChestplate();
            this.leggings = p2.getInventory().getLeggings();
            this.boots = p2.getInventory().getBoots();
            this.owner = p2.getName();
            this.dead = p2.isDead();
            this.food = p2.getFoodLevel();
            this.effects = p2.getActivePotionEffects();
            this.mainInv = p2.getInventory().getContents();
            this.plugin = plugin;
            this.inventoryUUID = UUID.randomUUID();
            this.ownerUUID = p2.getUniqueId();
            Fight fight = AbstractFight.getCurrentFight(p2);
            if (fight != null) {
                this.statistics = fight.getStatistics(p2.getUniqueId());
                this.getRecordUUID(fight);
            }
            this.save();
        }
    }

    public FightInventory(StrikePractice plugin) {
        this.plugin = plugin;
    }

    public FightInventory(Entity ent, String name, PlayerInventory inv, StrikePractice plugin) {
        if (ent instanceof Damageable) {
            this.health = ((Damageable)ent).getHealth();
        }
        this.helmet = inv.getHelmet();
        this.chestplate = inv.getChestplate();
        this.leggings = inv.getLeggings();
        this.boots = inv.getBoots();
        this.owner = name;
        this.dead = ent.isDead();
        this.food = 20;
        if (ent instanceof LivingEntity) {
            this.effects = ((LivingEntity)ent).getActivePotionEffects();
        }
        this.mainInv = inv.getContents();
        this.plugin = plugin;
        this.inventoryUUID = UUID.randomUUID();
        this.ownerUUID = ent.getUniqueId();
        Fight fight = AbstractFight.getCurrentFight(ent.getUniqueId());
        if (fight != null) {
            this.statistics = fight.getStatistics(ent.getUniqueId());
        }
        this.getRecordUUID(fight);
        this.save();
    }

    @Deprecated
    public static FightInventory fromLegacyString(String fightInventory) {
        FightInventory fi = new FightInventory(StrikePractice.getInstance());
        String[] s2 = fightInventory.split(":");
        fi.setOwner(s2[0]);
        fi.setUUID(UUID.fromString(s2[1]));
        fi.setOwnerUUID(UUID.fromString(s2[2]));
        fi.setHealth(Double.parseDouble(s2[3]));
        fi.setDead(Boolean.parseBoolean(s2[4]));
        fi.setFood(Integer.parseInt(s2[5]));
        fi.setHelmet(ItemStackUtil.fromString((String)s2[6]));
        fi.setChestplate(ItemStackUtil.fromString((String)s2[7]));
        fi.setLeggings(ItemStackUtil.fromString((String)s2[8]));
        fi.setBoots(ItemStackUtil.fromString((String)s2[9]));
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (String is : s2[10].split("; ")) {
            items.add(ItemStackUtil.fromString((String)is));
        }
        fi.setMainInv(items.toArray(new ItemStack[36]));
        fi.setEffects(new ArrayList<PotionEffect>());
        if (s2.length > 12) {
            for (String ef : s2[11].split("; ")) {
                fi.getEffects().add(EffectUtil.fromString((String)ef));
            }
        }
        return fi;
    }

    public static void inventoryMessage(Player p2, Collection<String> winners, Collection<String> losers) {
        try {
            String winnersMessage;
            StrikePractice plugin = StrikePractice.getInstance();
            plugin.sendMessage(p2, "inventory-message");
            HashMap<String, String> map = new HashMap<String, String>(losers.size());
            String losersMessage = CommonUtil.translateColors((String)plugin.getConfig().getString("loser-inventories"));
            int c2 = 0;
            String separator = CommonUtil.translateColors((String)plugin.getConfig().getString("inventory-separator"));
            String i2 = CommonUtil.translateColors((String)plugin.getConfig().getString("fight-inventory-player"));
            if (!losersMessage.isEmpty()) {
                boolean msg = false;
                for (String asd : losers) {
                    FightInventory inv = plugin.getFightInventoryManager().getFightInventory(plugin.getFightInventoryManager().getInventoryUUIDByName(asd));
                    map.put(i2.replace("<player>", inv.isDead() ? ChatColor.RED + asd : ChatColor.GREEN + asd), "/clickablefightinventory " + inv.getUUID());
                    if ((++c2 != 3 || msg) && (!msg || c2 != 5)) continue;
                    c2 = 0;
                    if (!msg) {
                        msg = true;
                        ClickableMessage.sendMultipleMessages((Player)p2, map, (String)losersMessage, (String)separator);
                    } else {
                        ClickableMessage.sendMultipleMessages((Player)p2, map, (String)"", (String)separator);
                    }
                    map.clear();
                }
                if (c2 > 0) {
                    ClickableMessage.sendMultipleMessages((Player)p2, map, (String)losersMessage, (String)separator);
                }
                map.clear();
            }
            if (!(winnersMessage = CommonUtil.translateColors((String)plugin.getConfig().getString("winner-inventories"))).isEmpty()) {
                boolean msg2 = false;
                c2 = 0;
                for (String asd : winners) {
                    FightInventory inv = plugin.getFightInventoryManager().getFightInventory(plugin.getFightInventoryManager().getInventoryUUIDByName(asd));
                    map.put(i2.replace("<player>", inv.isDead() ? ChatColor.RED + asd : ChatColor.GREEN + asd), "/clickablefightinventory " + inv.getUUID());
                    if ((++c2 != 3 || msg2) && (!msg2 || c2 != 5)) continue;
                    c2 = 0;
                    if (!msg2) {
                        msg2 = true;
                        ClickableMessage.sendMultipleMessages((Player)p2, map, (String)winnersMessage, (String)separator);
                    } else {
                        ClickableMessage.sendMultipleMessages((Player)p2, map, (String)"", (String)separator);
                    }
                    map.clear();
                }
                if (c2 > 0) {
                    ClickableMessage.sendMultipleMessages((Player)p2, map, (String)winnersMessage, (String)separator);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void inventoryMessage(Player p2, Collection<FightInventory> invs) {
        try {
            StrikePractice plugin = StrikePractice.getInstance();
            HashMap<String, String> map = new HashMap<String, String>();
            String message = StrikePractice.getInstance().translateMessage(p2, "inventory-message", false, null)[0];
            int c2 = 0;
            boolean msg = false;
            HashMap<String, FightInventory> inventories = new HashMap<String, FightInventory>();
            for (FightInventory inv : invs) {
                if (inv == null || inv.getOwner() == null) continue;
                inventories.put(inv.getOwner(), inv);
            }
            String separator = CommonUtil.translateColors((String)plugin.getConfig().getString("inventory-separator"));
            String i2 = CommonUtil.translateColors((String)plugin.getConfig().getString("fight-inventory-player"));
            for (String asd : inventories.keySet()) {
                FightInventory inv = plugin.getFightInventoryManager().getFightInventory(plugin.getFightInventoryManager().getInventoryUUIDByName(asd));
                map.put(i2.replace("<player>", inv.isDead() ? ChatColor.RED + asd : ChatColor.GREEN + asd), "/clickablefightinventory " + inv.getUUID());
                if ((++c2 != 3 || msg) && (!msg || c2 != 4)) continue;
                c2 = 0;
                if (!msg) {
                    msg = true;
                    ClickableMessage.sendMultipleMessages((Player)p2, map, (String)message, (String)separator);
                } else {
                    ClickableMessage.sendMultipleMessages((Player)p2, map, (String)"", (String)separator);
                }
                map.clear();
            }
            if (c2 > 0) {
                ClickableMessage.sendMultipleMessages((Player)p2, map, (String)(msg ? "" : message), (String)separator);
            }
        }
        catch (Exception e2) {
            Bukkit.getLogger().info("Failed to send post-match inventory message to " + p2.getName());
            e2.printStackTrace();
        }
    }

    public static void message(Collection<String> ownParty, Collection<String> opponent) {
        try {
            StrikePractice plugin = StrikePractice.getInstance();
            for (String m2 : ownParty) {
                Player mem = PlayerUtil.getPlayer((String)m2);
                if (mem == null) continue;
                plugin.sendMessage(mem, "inventory-message");
            }
            String yourTeamMessage = CommonUtil.translateColors((String)plugin.getConfig().getString("inventory-message-your"));
            String playerFormat = CommonUtil.translateColors((String)plugin.getConfig().getString("fight-inventory-player"));
            String separator = CommonUtil.translateColors((String)plugin.getConfig().getString("inventory-separator"));
            FightInventory.sendToParty(ownParty, ownParty, plugin, playerFormat, separator, yourTeamMessage);
            String opponentMessage = CommonUtil.translateColors((String)plugin.getConfig().getString("inventory-message-opponent"));
            FightInventory.sendToParty(ownParty, opponent, plugin, playerFormat, separator, opponentMessage);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void sendToParty(Collection<String> party, Collection<String> opponent, StrikePractice plugin, String playerFormat, String separator, String opponentMessage) {
        boolean msg2 = false;
        int count = 0;
        FightInventoryManager finvMan = plugin.getFightInventoryManager();
        ArrayList<FightInventory> invs = new ArrayList<FightInventory>(opponent.size());
        HashMap<String, String> map = new HashMap<String, String>(opponent.size());
        for (String asd : opponent) {
            ++count;
            FightInventory inv = finvMan.getFightInventory(finvMan.getInventoryUUIDByName(asd));
            invs.add(inv);
            map.put(playerFormat.replace("<player>", inv.isDead() ? ChatColor.RED + asd : ChatColor.GREEN + asd), "/clickablefightinventory " + inv.getUUID());
            if ((count != 3 || msg2) && (!msg2 || count != 5)) continue;
            count = 0;
            for (String s2 : party) {
                Player mem = PlayerUtil.getPlayer((String)s2);
                if (mem == null) continue;
                if (!msg2) {
                    ClickableMessage.sendMultipleMessages((Player)mem, map, (String)opponentMessage, (String)separator);
                    continue;
                }
                ClickableMessage.sendMultipleMessages((Player)mem, map, (String)"", (String)separator);
            }
            msg2 = true;
            map.clear();
        }
        for (int i2 = 0; i2 < invs.size(); ++i2) {
            FightInventory inv = (FightInventory)invs.get(i2);
            if (inv.getNextInventory() != null) continue;
            int nextIndex = i2 == invs.size() - 1 ? 0 : i2 + 1;
            inv.setNextInventory((FightInventory)invs.get(nextIndex));
        }
        if (count > 0) {
            for (String s3 : party) {
                Player mem = PlayerUtil.getPlayer((String)s3);
                if (mem == null) continue;
                if (!msg2) {
                    ClickableMessage.sendMultipleMessages((Player)mem, map, (String)opponentMessage, (String)separator);
                    continue;
                }
                ClickableMessage.sendMultipleMessages((Player)mem, map, (String)"", (String)separator);
            }
        }
    }

    public static void duelMessage(Player winnerPlayer, Player loserPlayer, FightInventory winnerInv, FightInventory loserInv) {
        String winner = winnerPlayer.getName();
        String loser = loserPlayer.getName();
        FightInventory.duelMessage(winnerPlayer, loserPlayer, winner, loser, winnerInv, loserInv);
    }

    public static void duelMessage(Player winnerPlayer, Player loserPlayer, String winner, String loser, FightInventory winnerInv, FightInventory loserInv) {
        List messages = StrikePractice.getInstance().getConfig().getStringList("fight-inventory-message");
        ArrayList maps = new ArrayList();
        String noCommand = "/clickedchatwithoutaction";
        for (String s2 : messages) {
            String command;
            String[] w2;
            String command2;
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            String wPots = winnerInv.getPotionsLeft() == 0 ? (int)Math.ceil(winnerInv.getHealth()) + "\u2764" : winnerInv.getPotionsLeft() + "";
            String lPots = loserInv.getPotionsLeft() == 0 ? (int)Math.ceil(loserInv.getHealth()) + "\u2764" : loserInv.getPotionsLeft() + "";
            if (!(s2 = CommonUtil.translateColors((String)s2).replace("<winner_pots>", wPots).replace("<loser_pots>", lPots)).contains("<loser>") && s2.contains("<winner>")) {
                command2 = "/clickablefightinventory " + winnerInv.getUUID();
                map.put(s2.replace("<winner>", winner), command2);
            } else if (!s2.contains("<winner>") && s2.contains("<loser>")) {
                command2 = "/clickablefightinventory " + loserInv.getUUID();
                map.put(s2.replace("<loser>", loser), command2);
            } else if (!s2.contains("<winner>") && !s2.contains("<loser>")) {
                map.put(s2, noCommand);
            } else if (s2.indexOf("<win") < s2.indexOf("<los")) {
                w2 = s2.split("<win");
                if (w2[0].contains("<loser>")) {
                    command = "/clickablefightinventory " + loserInv.getUUID();
                    map.put(w2[0].replace("<loser>", loser), command);
                    if (w2.length > 1 && w2[1].contains("ner>")) {
                        w2[1] = w2[1].replace("ner>", "");
                        command = "/clickablefightinventory " + winnerInv.getUUID();
                        map.put(winner, command);
                    }
                } else if (w2.length > 1 && w2[1].contains("ner>")) {
                    w2[1] = w2[1].replace("ner>", "");
                    command = "/clickablefightinventory " + winnerInv.getUUID();
                    map.put(w2[0] + winner, command);
                } else {
                    map.put(w2[0], noCommand);
                }
                if (w2.length > 1) {
                    if (w2[1].contains("<loser>")) {
                        command = "/clickablefightinventory " + loserInv.getUUID();
                        map.put(w2[1].replace("<loser>", loser), command);
                    } else if (w2.length > 2 && w2[2].contains("ner>")) {
                        w2[2] = w2[2].replace("ner>", "");
                        command = "/clickablefightinventory " + winnerInv.getUUID();
                        map.put(w2[1] + winner, command);
                    } else {
                        map.put(w2[1], noCommand);
                    }
                    if (w2.length > 2) {
                        map.put(w2[2], noCommand);
                    }
                }
            } else {
                w2 = s2.split("<lo");
                if (w2[0].contains("<winner>")) {
                    command = "/clickablefightinventory " + winnerInv.getUUID();
                    map.put(w2[0].replace("<winner>", winner), command);
                    if (w2[1].contains("ser>")) {
                        w2[1] = w2[1].replace("ser>", "");
                        command = "/clickablefightinventory " + loserInv.getUUID();
                        map.put(loser, command);
                    }
                } else if (w2[1].contains("ser>")) {
                    w2[1] = w2[1].replace("ser>", "");
                    command = "/clickablefightinventory " + loserInv.getUUID();
                    map.put(w2[0] + loser, command);
                } else {
                    map.put(w2[0], noCommand);
                }
                if (w2[1].contains("<winner>")) {
                    command = "/clickablefightinventory " + winnerInv.getUUID();
                    map.put(w2[1].replace("<winner>", winner), command);
                } else if (w2.length > 2 && w2[2].contains("ser>")) {
                    w2[2] = w2[2].replace("ser>", "");
                    command = "/clickablefightinventory " + loserInv.getUUID();
                    map.put(w2[1] + loser, command);
                } else {
                    map.put(w2[1], noCommand);
                }
                if (w2.length > 2) {
                    map.put(w2[2], noCommand);
                }
            }
            maps.add(map);
        }
        if (winnerPlayer != null) {
            ClickableMessage.sendMultipleMessages((Player)winnerPlayer, maps);
        }
        if (loserPlayer != null && !loser.equalsIgnoreCase(winner)) {
            ClickableMessage.sendMultipleMessages((Player)loserPlayer, maps);
        }
    }

    private void getRecordUUID(Fight fight) {
        FightRecorder rec;
        if (fight instanceof Recordable && (rec = ((Recordable)((Object)fight)).getRecorder()) != null && rec.getRecordedMatch() != null) {
            this.playbackUUID = rec.getRecordedMatch().getUUID();
        }
    }

    public void save() {
        this.created = System.currentTimeMillis();
        for (ItemStack is : this.mainInv) {
            short d2;
            if (is == null || !is.getType().toString().contains("POTION") || (d2 = is.getDurability()) != 8197 && d2 != 8229 && d2 != 16389 && d2 != 16421 && d2 != 2586 && is.getType().getId() != 438) continue;
            this.left += is.getAmount() > 0 ? is.getAmount() : 1;
        }
        if (this.left == 0) {
            for (ItemStack is : this.mainInv) {
                if (is == null || is.getType() != Material.MUSHROOM_SOUP) continue;
                this.left += is.getAmount() > 0 ? is.getAmount() : 1;
            }
        } else {
            this.leftPotions = true;
        }
        this.plugin.getFightInventoryManager().saveInventory(this);
    }

    public Inventory build(Player p2) {
        Material otherInvMat;
        ItemMeta meta;
        int slots = this.getSlots();
        Inventory inv = Bukkit.createInventory((InventoryHolder)new FightInventoryHolder(this), (int)slots, (String)CommonUtil.translateColors((String)this.plugin.getConfig().getString("fight-inventory.inventory").replace("<player>", this.owner)));
        int a2 = this.plugin.getConfig().getInt("fight-inventory.item-start-slot") - 1;
        int counter = 0;
        for (int x2 = a2; x2 < 36 + a2 && x2 < slots; ++x2) {
            inv.setItem(x2, this.getMainInv()[counter]);
            ++counter;
        }
        inv.setItem(this.getSlot("helmet"), this.getHelmet());
        inv.setItem(this.getSlot("chestplate"), this.getChestplate());
        inv.setItem(this.getSlot("leggings"), this.getLeggings());
        inv.setItem(this.getSlot("boots"), this.getBoots());
        if (this.playbackUUID != null && this.plugin.citizens && PermissionsManager.hasPermission((CommandSender)p2, (Permission)Permission.PLAYBACK)) {
            block1: for (List matches : StrikePractice.getInstance().getRecordedMatchesManager().getRecordedDuels().values()) {
                for (RecordedMatch match : matches) {
                    if (match == null || this.playbackUUID != match.getUUID()) continue;
                    inv.setItem(this.getSlot("playback"), ReplayInventoryManager.buildItem((RecordedMatch)match));
                    continue block1;
                }
            }
        }
        if (this.isDead()) {
            ItemStack dead = new ItemStack(Material.SKULL_ITEM);
            meta = dead.getItemMeta();
            meta.setDisplayName(CommonUtil.translateColors((String)this.plugin.getConfig().getString("fight-inventory.dead")));
            dead.setItemMeta(meta);
            inv.setItem(this.getSlot("health"), dead);
        } else {
            double health = Math.ceil(this.getHealth());
            ItemStack hp = new ItemStack(Material.MELON, (int)health);
            ItemMeta meta2 = hp.getItemMeta();
            meta2.setDisplayName(CommonUtil.translateColors((String)this.plugin.getConfig().getString("fight-inventory.health")).replace("<health>", health + ""));
            hp.setItemMeta(meta2);
            inv.setItem(this.getSlot("health"), hp);
        }
        ItemStack food = new ItemStack(Material.COOKED_BEEF, this.getFood());
        meta = food.getItemMeta();
        meta.setDisplayName(CommonUtil.translateColors((String)this.plugin.getConfig().getString("fight-inventory.food")).replace("<food>", this.getFood() + ""));
        food.setItemMeta(meta);
        inv.setItem(this.getSlot("food"), food);
        ItemStack ef = new ItemStack(Material.POTION);
        ItemMeta efMeta = food.getItemMeta();
        efMeta.setDisplayName(CommonUtil.translateColors((String)this.plugin.getConfig().getString("fight-inventory.effect-displayname", "&7Potion Effects")));
        String effects = CommonUtil.translateColors((String)this.plugin.getConfig().getString("fight-inventory.pots"));
        efMeta.setLore(Arrays.asList(effects));
        ArrayList<String> lores = new ArrayList<String>();
        for (Object s2 : efMeta.getLore()) {
            lores.add((String)s2);
        }
        String f2 = CommonUtil.translateColors((String)this.plugin.getConfig().getString("fight-inventory.effect"));
        for (PotionEffect e2 : this.getEffects()) {
            lores.add(FormatUtils.formatPotionEffect((String)f2, (PotionEffect)e2));
        }
        efMeta.setLore(lores);
        ef.setItemMeta(efMeta);
        inv.setItem(this.getSlot("pots"), ef);
        if (this.getNextInventory() != null && (otherInvMat = Material.getMaterial((String)this.plugin.getConfig().getString("fight-inventory.next-inventory-item"))) != null) {
            ItemStack otherInvItem = new ItemStack(otherInvMat);
            ItemMeta otherInvMeta = otherInvItem.getItemMeta();
            otherInvMeta.setDisplayName(CommonUtil.translateColors((String)this.plugin.getConfig().getString("fight-inventory.next-inventory-name")).replace("<player>", this.getNextInventory().getOwner()));
            otherInvItem.setItemMeta(otherInvMeta);
            inv.setItem(this.getSlot("next-inventory"), otherInvItem);
        }
        if (this.leftPotions || this.left == 0) {
            ItemStack pots = new ItemStack(Material.POTION);
            ItemMeta potsMeta = this.applyStats(pots.getItemMeta());
            pots.setDurability((short)16421);
            pots.setAmount(this.left == 0 ? 1 : this.left);
            potsMeta.setDisplayName(CommonUtil.translateColors((String)this.plugin.getConfig().getString("fight-inventory.pots-left")).replace("<potions>", this.left + ""));
            pots.setItemMeta(potsMeta);
            inv.setItem(this.getSlot("pots-left"), pots);
        } else {
            ItemStack soups = new ItemStack(Material.MUSHROOM_SOUP);
            ItemMeta soupsMeta = this.applyStats(soups.getItemMeta());
            soups.setAmount(this.left == 0 ? 1 : this.left);
            soupsMeta.setDisplayName(CommonUtil.translateColors((String)this.plugin.getConfig().getString("fight-inventory.soups-left")).replace("<soups>", this.left + ""));
            soups.setItemMeta(soupsMeta);
            inv.setItem(this.getSlot("pots-left"), soups);
        }
        return inv;
    }

    private ItemMeta applyStats(ItemMeta meta) {
        if (this.statistics == null) {
            return meta;
        }
        ArrayList lores = new ArrayList();
        this.plugin.getConfig().getStringList("fight-inventory.match-stats-lore").forEach(s2 -> lores.add(CommonUtil.translateColors((String)s2).replace("<hits>", Integer.toString(this.statistics.getHits())).replace("<combo>", Integer.toString(this.statistics.getLongestCombo())).replace("<potions_thrown>", Integer.toString(this.statistics.getPotionsThrown())).replace("<potions_missed>", Integer.toString(this.statistics.getPotionsMissed())).replace("<potion_accuracy>", this.statistics.getAccuracy() + "%")));
        meta.setLore(lores);
        return meta;
    }

    public int getSlots() {
        return 9 * this.plugin.getConfig().getInt("fight-inventory.rows");
    }

    @Deprecated
    public String toLegacyString() {
        StringBuilder s2 = new StringBuilder();
        s2.append(this.owner);
        s2.append(":").append(this.ownerUUID.toString());
        s2.append(":").append(this.inventoryUUID.toString());
        s2.append(":").append(this.health);
        s2.append(":").append(this.dead);
        s2.append(":").append(this.food);
        s2.append(":").append(ItemStackUtil.itemToString((ItemStack)this.helmet));
        s2.append(":").append(ItemStackUtil.itemToString((ItemStack)this.chestplate));
        s2.append(":").append(ItemStackUtil.itemToString((ItemStack)this.leggings));
        s2.append(":").append(ItemStackUtil.itemToString((ItemStack)this.boots));
        String comma = "";
        s2.append(":");
        for (ItemStack is : this.mainInv) {
            s2.append(comma);
            s2.append(ItemStackUtil.itemToString((ItemStack)is));
            comma = ", ";
        }
        if (!this.effects.isEmpty()) {
            comma = "";
            s2.append(":");
            for (PotionEffect ef : this.effects) {
                s2.append(comma);
                s2.append(EffectUtil.effectToString((PotionEffect)ef));
                comma = ", ";
            }
        }
        return s2.toString();
    }

    public FightStatistics getStatistics() {
        return this.statistics;
    }

    public void setStatistics(FightStatistics statistics) {
        this.statistics = statistics;
    }

    public int getPotionsLeft() {
        return this.left;
    }

    public UUID getUUID() {
        return this.inventoryUUID;
    }

    public void setUUID(UUID uuid) {
        this.inventoryUUID = uuid;
    }

    private int getSlot(String s2) {
        int slots;
        int i2 = this.plugin.getConfig().getInt("fight-inventory." + s2 + "-slot");
        if (i2 >= (slots = this.getSlots())) {
            return slots - 1;
        }
        return i2;
    }

    public double getHealth() {
        return this.health;
    }

    public void setHealth(double health) {
        this.health = health;
    }

    public Collection<PotionEffect> getEffects() {
        return this.effects;
    }

    public void setEffects(Collection<PotionEffect> effects) {
        this.effects = effects;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public ItemStack[] getMainInv() {
        return this.mainInv;
    }

    public void setMainInv(ItemStack[] mainInv) {
        this.mainInv = mainInv;
    }

    public boolean isDead() {
        return this.dead;
    }

    public void setDead(boolean dead) {
        this.dead = dead;
    }

    public int getFood() {
        return this.food;
    }

    public void setFood(int food) {
        this.food = food;
    }

    public ItemStack getHelmet() {
        return this.helmet;
    }

    public void setHelmet(ItemStack helmet) {
        this.helmet = helmet;
    }

    public ItemStack getChestplate() {
        return this.chestplate;
    }

    public void setChestplate(ItemStack chestplate) {
        this.chestplate = chestplate;
    }

    public boolean createdLongTimeAgo() {
        return System.currentTimeMillis() - this.created > TimeUnit.MINUTES.toMillis(10L);
    }

    public ItemStack getLeggings() {
        return this.leggings;
    }

    public void setLeggings(ItemStack leggings) {
        this.leggings = leggings;
    }

    public ItemStack getBoots() {
        return this.boots;
    }

    public void setBoots(ItemStack boots) {
        this.boots = boots;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwnerUUID(UUID ownerUUID) {
        this.ownerUUID = ownerUUID;
    }

    public FightInventory getNextInventory() {
        return this.nextInventory;
    }

    public void setNextInventory(FightInventory nextInventory) {
        this.nextInventory = nextInventory;
    }
}

