/*
 * Decompiled with CFR 0.152.
 */
package ga.strikepractice.events;

import ga.strikepractice.api.APIClass;
import ga.strikepractice.bot.PracticeBot;
import ga.strikepractice.events.FightEndEvent;
import ga.strikepractice.fights.botduel.BotDuel;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.entity.Player;

@APIClass
public class BotDuelEndEvent
extends FightEndEvent {
    private final Player player;
    private final PracticeBot bot;
    private final String winner;
    private final WinnerType winnerType;

    public BotDuelEndEvent(BotDuel fight, Player player, PracticeBot bot, String winner, WinnerType winnerType) {
        super(fight);
        this.winnerType = winnerType;
        this.player = player;
        this.bot = bot;
        this.winner = winner;
    }

    public NPC getBot() {
        return this.bot.getNPC();
    }

    public Player getPlayer() {
        return this.player;
    }

    public String getWinner() {
        return this.winner;
    }

    public String getLoser() {
        if (this.winnerType == WinnerType.BOT) {
            return this.player.getName();
        }
        return this.getBot().getName();
    }

    public WinnerType getWinnerType() {
        return this.winnerType;
    }

    @Override
    public BotDuel getFight() {
        return (BotDuel)super.getFight();
    }

    @APIClass
    public static enum WinnerType {
        BOT,
        PLAYER;

    }
}

