/*
 * Decompiled with CFR 0.152.
 */
package ga.strikepractice.bot;

import ga.strikepractice.api.APIClass;
import ga.strikepractice.battlekit.BattleKit;
import ga.strikepractice.bot.BotSettings;
import ga.strikepractice.bot.PracticeBot;
import ga.strikepractice.bot.ai.AITrait;
import ga.strikepractice.bot.ai.CombatVersion;
import ga.strikepractice.fights.AbstractFight;
import ga.strikepractice.fights.Fight;
import ga.strikepractice.utils.NPCUtil;
import java.util.List;
import java.util.UUID;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;

@APIClass
public class FightBot
extends PracticeBot {
    private final BotSettings settings;

    public FightBot(BotSettings settings, Location location, List<UUID> targets, Fight fight) {
        this.settings = settings;
        this.npc = settings.createNPC(location);
        if (this.npc != null) {
            this.npc.setProtected(false);
            AITrait trait = (AITrait)this.npc.getOrAddTrait(CombatVersion.get().getTrait());
            trait.setTargets(targets);
            AbstractFight.setCurrentFight(trait.asValidPlayer(), fight);
            NPCUtil.applyKit((NPC)this.npc, (BattleKit)fight.getKit());
        }
    }

    public BotSettings getSettings() {
        return this.settings;
    }

    @Override
    public void destroy() {
        if (this.npc.isSpawned()) {
            this.npc.despawn();
            this.npc.destroy();
        }
    }

    @Override
    public boolean isLegacy() {
        return false;
    }
}

