/*
 * Decompiled with CFR 0.152.
 */
package ga.strikepractice.battlekit;

import ga.strikepractice.api.APIClass;
import java.util.Arrays;
import java.util.Optional;

@APIClass
public enum BattleKitType {
    ANY,
    DUEL,
    BOT_FIGHT,
    QUEUE,
    PARTY_VS_PARTY,
    PARTY_FFA,
    PARTY_SPLIT,
    PREMIUM_QUEUE,
    PARTY_QUEUE,
    BRACKETS,
    LMS,
    NONE;


    public static BattleKitType byName(String t2) {
        Optional<BattleKitType> type = Arrays.stream(BattleKitType.values()).filter(it -> it.toString().equalsIgnoreCase(t2)).findFirst();
        if (type.isPresent()) {
            return type.get();
        }
        if (t2.contains("any")) {
            return ANY;
        }
        if (t2.contains("ffa")) {
            return PARTY_FFA;
        }
        if (t2.contains("split")) {
            return PARTY_SPLIT;
        }
        if (t2.contains("party")) {
            return PARTY_VS_PARTY;
        }
        if (t2.contains("2v2") || t2.contains("party") && t2.contains("queue")) {
            return PARTY_QUEUE;
        }
        if (t2.contains("duel")) {
            return DUEL;
        }
        if (t2.contains("bot")) {
            return BOT_FIGHT;
        }
        if (t2.contains("queue")) {
            return QUEUE;
        }
        if (t2.contains("premium")) {
            return PREMIUM_QUEUE;
        }
        if (t2.contains("none")) {
            return NONE;
        }
        return null;
    }
}

