/*
 * Decompiled with CFR 0.152.
 */
package ga.strikepractice.battlekit;

import ga.strikepractice.StrikePractice;
import ga.strikepractice.api.APIClass;
import ga.strikepractice.battlekit.BattleKit;
import ga.strikepractice.battlekit.BattleKitType;
import ga.strikepractice.battlekit.DefaultBattleKit;
import ga.strikepractice.events.KitDeselectEvent;
import ga.strikepractice.scoreboard.HealthBar;
import ga.strikepractice.utils.Explosion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.metadata.Metadatable;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@APIClass
public interface BattleKit
extends ConfigurationSerializable {
    public static final String CURRENT_KIT = "StrikPracticeCurrentBattleKit";
    public static final String BATTLE_KIT_HORSE = "StrikPracticeBattleKitHorse";

    @Nullable
    public static BattleKit getKit(String name) {
        for (BattleKit bk : StrikePractice.getInstance().kits) {
            if (!bk.getName().equalsIgnoreCase(name)) continue;
            return bk;
        }
        return null;
    }

    @Nullable
    public static BattleKit getKit(Player p2, ItemStack icon, boolean includeRanked) {
        StrikePractice plugin = StrikePractice.getInstance();
        BattleKit custom = plugin.getPlayerKitsHandler().getPlayerKits(p2).getCustomKit();
        if (custom != null && custom.getIcon() != null && icon.equals((Object)custom.getIcon())) {
            return custom;
        }
        for (BattleKit bk : BattleKit.getKits(icon)) {
            if ((!bk.isElo() || !includeRanked) && bk.isElo()) continue;
            return bk;
        }
        return null;
    }

    @Nullable
    public static BattleKit getKit(ItemStack icon) {
        for (BattleKit bk : StrikePractice.getInstance().kits) {
            if (bk.getIcon() == null || !bk.getIcon().getType().equals((Object)icon.getType()) || bk.getIcon().getDurability() != icon.getDurability() || bk.getIcon().getItemMeta().hasDisplayName() && icon.getItemMeta().hasDisplayName() && !bk.getIcon().getItemMeta().getDisplayName().equals(icon.getItemMeta().getDisplayName())) continue;
            return bk;
        }
        return null;
    }

    public static List<BattleKit> getKits(ItemStack icon) {
        ArrayList<BattleKit> kits = new ArrayList<BattleKit>(1);
        if (icon == null) {
            return kits;
        }
        for (BattleKit bk : StrikePractice.getInstance().kits) {
            if (bk.getIcon() == null || bk.getIcon().getType() == null || !bk.getIcon().getType().equals((Object)icon.getType()) || bk.getIcon().getDurability() != icon.getDurability() || bk.getIcon().getItemMeta().hasDisplayName() && !bk.getIcon().getItemMeta().getDisplayName().equals(icon.getItemMeta().getDisplayName())) continue;
            kits.add(bk);
        }
        return kits;
    }

    @Nullable
    public static BattleKit getCurrentKit(@NotNull Metadatable metadatable) {
        MetadataValue m2;
        if (metadatable.hasMetadata(CURRENT_KIT) && (m2 = StrikePractice.getInstance().getMetadata(metadatable, CURRENT_KIT)) != null && m2.value() != null && m2.value() instanceof BattleKit) {
            return (BattleKit)m2.value();
        }
        return null;
    }

    public static void deselectKit(Player p2) {
        BattleKit kit = BattleKit.getCurrentKit((Metadatable)p2);
        KitDeselectEvent event = new KitDeselectEvent(p2);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (kit != null && kit.isHorse()) {
            for (World w2 : Bukkit.getWorlds()) {
                for (Horse horse : w2.getEntitiesByClass(Horse.class)) {
                    MetadataValue m2;
                    if (!horse.hasMetadata(BATTLE_KIT_HORSE) || (m2 = StrikePractice.getInstance().getMetadata((Metadatable)horse, BATTLE_KIT_HORSE)) == null || m2.value() == null || !m2.asString().equals(p2.getName())) continue;
                    horse.remove();
                }
            }
        }
        StrikePractice plugin = StrikePractice.getInstance();
        p2.setMaximumNoDamageTicks(BattleKitHitDelay.defaultHitDelay);
        p2.removeMetadata(CURRENT_KIT, (Plugin)plugin);
        HealthBar.unregisterHealthBar((Player)p2);
    }

    public static BattleKit createKit(String name) {
        return new DefaultBattleKit(name);
    }

    public void saveForStrikePractice();

    public boolean removeFromStrikePractice();

    public boolean isStrikePracticeKit();

    public void giveKitMeta(Metadatable var1);

    public void giveKit(Player var1);

    @Deprecated
    public HashSet<Material> getBlocks();

    public Set<Material> getBlockMaterials();

    public void fillEmptySlotsWithAir();

    public boolean canBreakBlock(Block var1);

    public void setOnlyBow(boolean var1);

    public void setBoots(ItemStack var1);

    @Deprecated
    public HashSet<BattleKitType> getTypes();

    public Set<BattleKitType> getKitTypes();

    public void setTypes(Set<BattleKitType> var1);

    public void setChestplate(ItemStack var1);

    public void setHelmet(ItemStack var1);

    public void setLeggings(ItemStack var1);

    public boolean isChestAccess();

    public void setChestAccess(boolean var1);

    public String getMergedEditor();

    public void setMergedEditor(String var1);

    public void setInventory(List<ItemStack> var1);

    public void setBestOf(int var1);

    public int getBestOf();

    public void setBlockDisappear(int var1);

    public int getBlockDisappear();

    public void setPearlCooldown(int var1);

    public int getPearlCooldown();

    public void setNoDamage(boolean var1);

    public boolean isNoDamage();

    public void setAutoTNT(boolean var1);

    public boolean isAutoTNT();

    public void setShootFireballs(boolean var1);

    public boolean isShootFireballs();

    public void setTNTJumps(boolean var1);

    public boolean isTNTJumps();

    public void setFireballJumps(boolean var1);

    public boolean isFireballJumps();

    public boolean isEditable();

    public void setEditable(boolean var1);

    public void setPotions(Collection<PotionEffect> var1);

    public void setBuild(boolean var1);

    public void setName(String var1);

    public ItemStack getBoots();

    public ItemStack getLeggings();

    public ItemStack getChestplate();

    public ItemStack getHelmet();

    public List<ItemStack> getInventory();

    public ItemStack[] getInv();

    public Collection<PotionEffect> getPotions();

    public ItemStack getIcon();

    public boolean isAnticheatProtected();

    public void setAnticheatProtected(boolean var1);

    public void setIcon(ItemStack var1);

    public String getName();

    public boolean isOnlyBow();

    public void setCombo(boolean var1);

    public void setElo(boolean var1);

    public void setHorse(boolean var1);

    public boolean isCombo();

    @Deprecated
    public HashSet<Material> getRollbackExtraMaterials();

    public Set<Material> getExtraMaterials();

    public Set<String> getExtraMaterialNames();

    public void addExtraRollbackMaterial(Material var1);

    public void addExtraRollbackMaterial(String var1);

    public void setRollbackExtraMaterials(Set<Material> var1);

    public boolean isElo();

    public boolean isHorse();

    public void setNoHunger(boolean var1);

    public boolean isNoHunger();

    public boolean isBuild();

    public boolean isStickSpawn();

    public boolean isBedwars();

    public void setBedwars(boolean var1);

    public boolean isBridges();

    public void setBridges(boolean var1);

    public boolean isParkour();

    public void setParkour(boolean var1);

    public boolean isHealthbar();

    public void setHealthbar(boolean var1);

    public boolean isNoFallDamage();

    public void setNoFallDamage(boolean var1);

    public void setStickSpawn(boolean var1);

    public boolean isNoBestOfRollback();

    public void setNoDeathCountdown(boolean var1);

    public void setNoBestOfRollback(boolean var1);

    public boolean isNoDeathCountdown();

    public void sendFightInfo(Player var1);

    public String getFancyName();

    public void giveKitStuff(Player var1, BattleKit var2);

    public boolean isBoxing();

    public void setBoxing(boolean var1);

    public void setBedExplosion(Explosion var1);

    default public boolean isRandomKit() {
        return this.getName().contains("randomkit");
    }

    @Nullable
    public Explosion getBedExplosion();

    public void setKillRegen(boolean var1);

    public boolean isKillRegen();
}

