/*
 * Decompiled with CFR 0.152.
 */
package ga.strikepractice.arena;

import ga.strikepractice.api.APIClass;
import ga.strikepractice.arena.CachedBlockChange;
import ga.strikepractice.arena.blockupdate.BlockUpdaterProvider;
import ga.strikepractice.utils.BlockDataUtil;
import ga.strikepractice.utils.ItemStackUtil;
import ga.strikepractice.utils.SPDebugger;
import ga.strikepractice.utils.SerializableLocation;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

@APIClass
public class DefaultCachedBlockChange
implements CachedBlockChange {
    private final Material oldMaterial;
    private final byte oldData;
    private final Location location;
    @Nullable
    private Object blockData;
    private ItemStack[] chestInventory;
    private boolean isResetSupported = true;

    public DefaultCachedBlockChange(Location location, Block oldBlock) {
        this(location, oldBlock.getType(), oldBlock.getData());
        this.blockData = BlockDataUtil.getBlockData((Block)oldBlock);
        boolean bl = this.isResetSupported = !ItemStackUtil.isNewMaterial((Block)oldBlock) || this.blockData != null;
        if (!this.isResetSupported) {
            SPDebugger.debug((String)("Change not supported for resetting, possibly because it's a new material: " + this));
        } else if (SPDebugger.getTRACE()) {
            SPDebugger.trace((String)("Change supported for resetting: " + this));
        }
    }

    public DefaultCachedBlockChange(Location location, Material type, byte data) {
        if (type == null) {
            type = Material.AIR;
        }
        this.oldMaterial = type;
        this.oldData = data;
        this.location = location;
        this.saveChest(location);
        if (SPDebugger.getTRACE()) {
            SPDebugger.trace((String)("Created block change " + this));
        }
    }

    @Deprecated
    public static CachedBlockChange getByLocation(Location l2, Collection<DefaultCachedBlockChange> list) {
        for (CachedBlockChange cachedBlockChange : list) {
            if (!l2.equals((Object)cachedBlockChange.getLocation())) continue;
            return cachedBlockChange;
        }
        return null;
    }

    private void saveChest(Location loc) {
        block4: {
            try {
                Block b2 = loc.getBlock();
                if (b2.getType() == Material.CHEST || b2.getType() == Material.TRAPPED_CHEST) {
                    Chest chest = (Chest)b2.getState();
                    InventoryHolder h2 = chest.getInventory().getHolder();
                    for (ItemStack is : this.chestInventory = (ItemStack[])Arrays.stream(h2.getInventory().getContents()).map(it -> it == null ? new ItemStack(Material.AIR) : it.clone()).toArray(ItemStack[]::new)) {
                        if (is == null || is.getAmount() != 0) continue;
                        is.setAmount(1);
                    }
                }
            }
            catch (Exception e2) {
                Bukkit.getLogger().info("StrikePractice >> Arena regen failed to save chest contents");
                if (!SPDebugger.getDEBUG()) break block4;
                e2.printStackTrace();
            }
        }
    }

    @Override
    public void reset(boolean forceNative) {
        try {
            if (this.location != null && this.oldMaterial != null) {
                if (this.blockData != null) {
                    if (SPDebugger.getTRACE()) {
                        SPDebugger.trace((String)("Resetting blockdata only: " + this.blockData));
                    }
                    BlockDataUtil.setBlockData((Block)this.location.getBlock(), (Object)this.blockData);
                } else {
                    BlockUpdaterProvider.getBlockUpdater((boolean)forceNative).resetBlockChange((CachedBlockChange)this);
                    if (this.chestInventory != null && (this.oldMaterial == Material.CHEST || this.oldMaterial == Material.TRAPPED_CHEST)) {
                        Block b2 = this.location.getBlock();
                        Chest chest = (Chest)b2.getState();
                        InventoryHolder h2 = chest.getInventory().getHolder();
                        h2.getInventory().setContents(this.chestInventory);
                        for (ItemStack is : h2.getInventory().getContents()) {
                            if (is == null || is.getAmount() > 0) continue;
                            is.setAmount(1);
                        }
                    }
                }
            }
        }
        catch (Exception e2) {
            Bukkit.getLogger().warning("Failed to reset arena block " + this);
            e2.printStackTrace();
        }
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public Material getOldMaterial() {
        return this.oldMaterial;
    }

    @Override
    public short getOldData() {
        return this.oldData;
    }

    @Override
    public int getX() {
        return this.location.getBlockX();
    }

    @Override
    public int getY() {
        return this.location.getBlockY();
    }

    @Override
    public int getZ() {
        return this.location.getBlockZ();
    }

    @Override
    public boolean isResetSupported() {
        return this.isResetSupported;
    }

    @Override
    public String toString() {
        return new SerializableLocation(this.getLocation()).toReadableString() + ":" + this.getOldMaterial() + ":" + this.getOldData() + ", blockData=" + this.blockData + ", chestInventory=" + Arrays.toString(this.chestInventory) + ", isResetSupported=" + this.isResetSupported;
    }
}

