/*
 * Decompiled with CFR 0.152.
 */
package ga.strikepractice.api;

import ga.strikepractice.api.APIClass;
import ga.strikepractice.arena.Arena;
import ga.strikepractice.battlekit.BattleKit;
import ga.strikepractice.fights.Fight;
import ga.strikepractice.fights.duel.Duel;
import ga.strikepractice.fights.elo.EloCalculator;
import ga.strikepractice.fights.queue.DuelQueueRunnable;
import ga.strikepractice.party.Party;
import ga.strikepractice.playerkits.PlayerKits;
import ga.strikepractice.playersettings.PlayerSettings;
import ga.strikepractice.stats.PlayerStats;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@APIClass
public interface StrikePracticeAPI {
    @Nullable
    public UUID getCurrentFightsPlaybackUUID(@NotNull Player var1);

    public boolean startPlayback(@NotNull Player var1, @NotNull UUID var2);

    @Nullable
    public Party getParty(@NotNull Player var1);

    public Party createParty(@NotNull Player var1);

    public void spawnBot(@NotNull Location var1, @NotNull String var2, @NotNull String var3, @NotNull List<UUID> var4, @NotNull String var5, @NotNull Fight var6);

    @Deprecated
    public void forceWin(@NotNull Player var1);

    public void forceWinFight(@NotNull Player var1);

    public void forceWinRound(@NotNull Player var1);

    public boolean isEditingKit(@NotNull Player var1);

    @Nullable
    public BattleKit getEditingKit(@NotNull Player var1);

    public void startEditing(@NotNull Player var1, @NotNull BattleKit var2);

    public void joinQueue(@NotNull Player var1, @NotNull BattleKit var2, boolean var3);

    public void joinQueue(@NotNull Player var1, @NotNull BattleKit var2);

    public void joinPremiumQueue(@NotNull Player var1, @NotNull BattleKit var2);

    public void cancelFight(@NotNull Player var1, @Nullable String var2);

    @NotNull
    public PlayerStats getPlayerStats(@NotNull Player var1);

    @Nullable
    public PlayerStats getPlayerStats(@NotNull UUID var1, boolean var2, boolean var3);

    public void clear(@NotNull Player var1, boolean var2, boolean var3);

    public Location getSpawnLocation();

    public boolean isSpectator(@NotNull Player var1);

    @Nullable
    public Fight getSpectating(@NotNull Player var1);

    public void addSpectator(@NotNull Player var1);

    public void addSpectator(@NotNull Player var1, @Nullable Player var2);

    public void removeSpectator(@NotNull Player var1, boolean var2);

    public boolean isInFight(@NotNull Player var1);

    public boolean isInEvent(@NotNull Player var1);

    public String getLanguage(@NotNull Player var1);

    public boolean isRanked(@NotNull Player var1);

    @NotNull
    public Map<BattleKit, String> getUnrankedQueue();

    @NotNull
    public Map<BattleKit, Collection<DuelQueueRunnable>> getRankedQueue();

    @Nullable
    public BattleKit getQueuedKit(@NotNull Player var1);

    public boolean isInQueue(@NotNull Player var1);

    public void setLanguage(@NotNull Player var1, String var2, boolean var3);

    @Nullable
    public Fight getFight(@NotNull Player var1);

    @Nullable
    public BattleKit getKit(@NotNull Player var1);

    @NotNull
    public JavaPlugin getStrikePractice();

    @Nullable
    public Player getDuelOpponent(@NotNull Player var1);

    @Nullable
    public Arena getArena(@NotNull String var1);

    @NotNull
    public List<Arena> getArenas();

    @Nullable
    public BattleKit getKit(@NotNull String var1);

    @Nullable
    public List<BattleKit> getKits(@NotNull ItemStack var1);

    @NotNull
    public List<BattleKit> getKits();

    @NotNull
    public EloCalculator getEloCalculator();

    public void setEloCalculator(@NotNull EloCalculator var1);

    @NotNull
    public PlayerSettings getPlayerSettings(@NotNull Player var1);

    @NotNull
    public PlayerKits loadPlayerKits(@NotNull UUID var1);

    @NotNull
    public PlayerKits getPlayerKits(@NotNull Player var1);

    @NotNull
    public Duel sendDuelRequest(@NotNull Player var1, @NotNull Player var2, @NotNull BattleKit var3, @NotNull Arena var4, boolean var5);

    @NotNull
    public Duel sendDuelRequest(@NotNull Player var1, @NotNull Player var2, @NotNull BattleKit var3, @NotNull Arena var4, int var5, boolean var6);

    @Nullable
    public BattleKit getLastSelectedEditedKit(@NotNull Player var1);

    public void respawnInFight(@NotNull Player var1);
}

